/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.logging.Level;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.RasterLayer;

public class GridCoverageLayer
extends RasterLayer {
    protected GridCoverage2D coverage;

    public GridCoverageLayer(GridCoverage2D coverage, Style style) {
        super(style);
        this.coverage = coverage;
    }

    public GridCoverageLayer(GridCoverage2D coverage, Style style, String title) {
        super(style, title);
        this.coverage = coverage;
    }

    @Override
    public void dispose() {
        this.preDispose();
        if (this.coverage != null) {
            try {
                this.coverage.dispose(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.coverage = null;
        }
        if (this.style != null) {
            this.style = null;
        }
        super.dispose();
    }

    public GridCoverage2D getCoverage() {
        return this.coverage;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        if (this.coverage != null) {
            CoordinateReferenceSystem crs = this.coverage.getCoordinateReferenceSystem();
            ReferencedEnvelope bounds = this.coverage.getEnvelope2D();
            if (bounds != null) {
                return new ReferencedEnvelope(bounds);
            }
            if (crs != null) {
                return new ReferencedEnvelope(crs);
            }
        }
        return null;
    }

    @Override
    public SimpleFeatureCollection toFeatureCollection() {
        try {
            SimpleFeatureCollection collection = FeatureUtilities.wrapGridCoverage((GridCoverage2D)this.coverage);
            return collection;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Coverage could not be converted to FeatureCollection", e);
            return null;
        }
    }
}

