/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fao.geonet.kernel.region.Region;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.TransformException;

@XmlRootElement(name="response")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ListRegionsResponse {
    @XmlAttribute
    @JsonProperty(value="count")
    private int count;
    @XmlElement
    @JsonProperty
    private final Collection<RegionResponse> region = Lists.newArrayList();
    @XmlElement
    @JsonProperty
    private final Map<String, CategoryResponse> categories = Maps.newHashMap();

    public ListRegionsResponse() {
    }

    public ListRegionsResponse(Collection<Region> regions) throws TransformException, FactoryException {
        this.count = regions.size();
        for (Region region : regions) {
            this.region.add(new RegionResponse(region));
            if (this.categories.containsKey(region.getCategoryId())) continue;
            this.categories.put(region.getCategoryId(), new CategoryResponse(region));
        }
    }

    public int size() {
        return this.region.size();
    }

    public Collection<RegionResponse> getRegions() {
        return this.region;
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class CategoryResponse {
        @XmlElement
        @JsonProperty
        private Map<String, String> label = Maps.newHashMap();

        public CategoryResponse() {
        }

        public CategoryResponse(Region region) {
            this.label = region.getCategoryLabels();
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RegionResponse {
        @XmlAttribute
        @JsonProperty(value="hasGeom")
        private boolean hasGeom;
        @XmlAttribute
        @JsonProperty(value="categoryId")
        private String categoryId;
        @XmlAttribute
        @JsonProperty(value="id")
        private String id;
        @XmlElement
        @JsonProperty
        private double north;
        @XmlElement
        @JsonProperty
        private double east;
        @XmlElement
        @JsonProperty
        private double south;
        @XmlElement
        @JsonProperty
        private double west;
        @XmlElement
        @JsonProperty
        private Map<String, String> label = Maps.newHashMap();

        public RegionResponse() {
        }

        public RegionResponse(Region input) throws TransformException, FactoryException {
            this.id = input.getId();
            this.north = input.getLatLongBBox().getMaxY();
            this.south = input.getLatLongBBox().getMinY();
            this.east = input.getLatLongBBox().getMaxX();
            this.west = input.getLatLongBBox().getMinX();
            this.label = input.getLabels();
            this.categoryId = input.getCategoryId();
            this.hasGeom = input.hasGeom();
        }

        public String getId() {
            return this.id;
        }
    }
}

