/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.mapservers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.mapservers.GeoServerNode;
import org.fao.geonet.api.mapservers.GeoServerRest;
import org.fao.geonet.api.mapservers.MapServersUtils;
import org.fao.geonet.api.mapservers.model.AnonymousMapserver;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.MapServer;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MapServerRepository;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/mapservers"})
@Tag(name="mapservers", description="Mapservers related operations")
@Controller(value="mapservers")
public class MapServersApi {
    public static final String API_PARAM_MAPSERVER_IDENTIFIER = "Mapserver identifier";
    public static final String API_PARAM_MAPSERVER_DETAILS = "Mapserver details";
    public static final String MSG_MAPSERVER_WITH_ID_NOT_FOUND = "Mapserver with id '%s' not found.";
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    MapServerRepository mapServerRepository;
    @Autowired
    @Qualifier(value="resourceStore")
    Store store;
    @Autowired
    SettingManager settingManager;
    @Autowired
    GeonetHttpRequestFactory requestFactory;

    @Operation(summary="Get mapservers", description="Mapservers are used by the catalog to publish record attachments (eg. ZIP file with shape) or record associated resources (eg. database table, file on the local network) in a remote mapserver like GeoServer or MapServer. The catalog communicate with the mapserver using GeoServer REST API.")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of all mapservers."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    public List<AnonymousMapserver> getMapservers() throws Exception {
        List mapServers = this.mapServerRepository.findAll();
        ArrayList<AnonymousMapserver> list = new ArrayList<AnonymousMapserver>(mapServers.size());
        mapServers.stream().forEach(e -> list.add(new AnonymousMapserver((MapServer)e)));
        return list;
    }

    @Operation(summary="Get a mapserver")
    @RequestMapping(value={"/{mapserverId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    public AnonymousMapserver getMapserver(@Parameter(description="Mapserver identifier", required=true, example="") @PathVariable String mapserverId) throws Exception {
        MapServer mapserver = this.mapServerRepository.findOneById(Integer.valueOf(mapserverId).intValue());
        if (mapserver == null) {
            throw new ResourceNotFoundException(String.format(MSG_MAPSERVER_WITH_ID_NOT_FOUND, mapserverId));
        }
        return new AnonymousMapserver(mapserver);
    }

    @Operation(summary="Add a mapserver", description="Return the id of the newly created mapserver.")
    @RequestMapping(method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Mapserver created."), @ApiResponse(responseCode="400", description="Bad parameters."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Reviewvers can access it.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<Integer> addMapserver(@Parameter(description="Mapserver details", required=true) @RequestBody MapServer mapserver) throws Exception {
        MapServer existingMapserver = this.mapServerRepository.findOneById(mapserver.getId());
        if (existingMapserver != null) {
            throw new IllegalArgumentException(String.format("Mapserver with id '%d' already exists.", mapserver.getId()));
        }
        this.mapServerRepository.save((Object)mapserver);
        return new ResponseEntity((Object)mapserver.getId(), HttpStatus.CREATED);
    }

    @Operation(summary="Update a mapserver")
    @RequestMapping(value={"/{mapserverId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Mapserver updated.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Reviewvers can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void updateMapserver(@Parameter(description="Mapserver identifier", required=true, example="") @PathVariable Integer mapserverId, @Parameter(description="Mapserver details", required=true) @RequestBody MapServer mapserver) throws Exception {
        MapServer existingMapserver = this.mapServerRepository.findOneById(mapserverId.intValue());
        if (existingMapserver == null) {
            throw new ResourceNotFoundException(String.format(MSG_MAPSERVER_WITH_ID_NOT_FOUND, mapserverId));
        }
        this.updateMapserver(mapserverId, mapserver, this.mapServerRepository);
    }

    @Operation(summary="Update a mapserver authentication", description="The remote mapserver REST API may require basic authentication. This operation set the username and password.")
    @RequestMapping(value={"/{mapserverId}/auth"}, method={RequestMethod.POST}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Mapserver updated.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Reviewvers can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateMapserverAuth(@Parameter(description="Mapserver identifier", required=true, example="") @PathVariable Integer mapserverId, @Parameter(description="User name", required=true) @RequestParam String username, @Parameter(description="Password", required=true) @RequestParam String password) throws Exception {
        MapServer existingMapserver = this.mapServerRepository.findOneById(mapserverId.intValue());
        if (existingMapserver == null) {
            throw new ResourceNotFoundException(String.format(MSG_MAPSERVER_WITH_ID_NOT_FOUND, mapserverId));
        }
        this.mapServerRepository.update((Serializable)mapserverId, entity -> {
            entity.setUsername(username);
            entity.setPassword(password);
        });
    }

    private void updateMapserver(int mapserverId, MapServer mapServer, MapServerRepository repository) {
        repository.update((Serializable)Integer.valueOf(mapserverId), entity -> {
            entity.setName(mapServer.getName());
            entity.setConfigurl(mapServer.getConfigurl());
            entity.setWmsurl(mapServer.getWmsurl());
            entity.setWfsurl(mapServer.getWfsurl());
            entity.setWcsurl(mapServer.getWcsurl());
            entity.setStylerurl(mapServer.getStylerurl());
            entity.setDescription(mapServer.getDescription());
            entity.setNamespace(mapServer.getNamespace());
            entity.setNamespacePrefix(mapServer.getNamespacePrefix());
            entity.setPushStyleInWorkspace(mapServer.pushStyleInWorkspace());
        });
    }

    @Operation(summary="Remove a mapserver")
    @RequestMapping(value={"/{mapserverId}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Mapserver removed.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Reviewvers can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteMapserver(@Parameter(description="Mapserver identifier", required=true) @PathVariable Integer mapserverId) throws Exception {
        MapServer m = this.mapServerRepository.findOneById(mapserverId.intValue());
        if (m == null) {
            throw new ResourceNotFoundException(String.format(MSG_MAPSERVER_WITH_ID_NOT_FOUND, mapserverId));
        }
        this.mapServerRepository.delete((Object)m);
    }

    @Operation(summary="Check metadata mapserver resource is published ")
    @RequestMapping(value={"/{mapserverId}/records/{metadataUuid}"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    public String getMapserverResource(@Parameter(description="Mapserver identifier", required=true, example="") @PathVariable String mapserverId, @Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Resource name (could be a file or a db connection)", required=true) @RequestParam String resource, @Parameter(description="Metadata title") @RequestParam(required=false, defaultValue="") String metadataTitle, @Parameter(description="Metadata abstract") @RequestParam(required=false, defaultValue="") String metadataAbstract, HttpServletRequest request) throws Exception {
        MapServersUtils.ACTION action = MapServersUtils.ACTION.GET;
        return this.publishResource(mapserverId, metadataUuid, resource, metadataTitle, metadataAbstract, request, action);
    }

    @Operation(summary="Publish a metadata resource in a mapserver")
    @RequestMapping(value={"/{mapserverId}/records/{metadataUuid}"}, method={RequestMethod.PUT}, produces={"text/plain"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @ResponseBody
    public String publishMapserverResource(@Parameter(description="Mapserver identifier", required=true, example="") @PathVariable String mapserverId, @Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Resource name (could be a file or a db connection)", required=true) @RequestParam String resource, @Parameter(description="Metadata title") @RequestParam(required=false, defaultValue="") String metadataTitle, @Parameter(description="Metadata abstract") @RequestParam(required=false, defaultValue="") String metadataAbstract, HttpServletRequest request) throws Exception {
        MapServersUtils.ACTION action = MapServersUtils.ACTION.CREATE;
        return this.publishResource(mapserverId, metadataUuid, resource, metadataTitle, metadataAbstract, request, action);
    }

    @Operation(summary="Remove a metadata mapserver resource")
    @RequestMapping(value={"/{mapserverId}/records/{metadataUuid}"}, method={RequestMethod.DELETE}, produces={"text/plain"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @ResponseBody
    public String deleteMapserverResource(@Parameter(description="Mapserver identifier", required=true, example="") @PathVariable String mapserverId, @Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Resource name (could be a file or a db connection)", required=true) @RequestParam String resource, @Parameter(description="Metadata title") @RequestParam(required=false, defaultValue="") String metadataTitle, @Parameter(description="Metadata abstract") @RequestParam(required=false, defaultValue="") String metadataAbstract, HttpServletRequest request) throws Exception {
        MapServersUtils.ACTION action = MapServersUtils.ACTION.DELETE;
        return this.publishResource(mapserverId, metadataUuid, resource, metadataTitle, metadataAbstract, request, action);
    }

    private String publishResource(String mapserverId, String metadataUuid, String resource, String metadataTitle, String metadataAbstract, HttpServletRequest request, MapServersUtils.ACTION action) throws Exception {
        metadataTitle = metadataTitle.replace("\\n", "");
        metadataAbstract = metadataAbstract.replace("\\n", "");
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        MapServer m = this.mapServerRepository.findOneById(Integer.valueOf(mapserverId).intValue());
        GeoServerNode g = new GeoServerNode(m);
        ServiceContext context = ApiUtils.createServiceContext(request);
        String baseUrl = this.settingManager.getSiteURL(context);
        GeoServerRest gs = new GeoServerRest(this.requestFactory, g.getUrl(), g.getUsername(), g.getUserpassword(), g.getNamespacePrefix(), baseUrl, this.settingManager.getNodeURL(), m.pushStyleInWorkspace());
        if (resource.startsWith("jdbc:postgresql")) {
            String[] values = resource.split("/");
            String[] serverInfo = values[2].split(":");
            String host = serverInfo[0];
            String port = serverInfo[1];
            String[] dbUserInfo = values[3].split("@");
            String[] userInfo = dbUserInfo[0].split(":");
            String user = userInfo[0];
            String password = userInfo[1];
            String[] dbInfo = dbUserInfo[1].split("#");
            String db = dbInfo[0];
            String table = dbInfo[1];
            return MapServersUtils.publishDbTable(action, gs, "postgis", host, port, user, password, db, table, "postgis", g.getNamespaceUrl(), metadataUuid, metadataTitle, metadataAbstract);
        }
        if (resource.startsWith("file://") || resource.startsWith("http://")) {
            return MapServersUtils.addExternalFile(action, gs, resource, metadataUuid, metadataTitle, metadataAbstract);
        }
        try (Store.ResourceHolder f = this.store.getResource(context, metadataUuid, resource);){
            String string = MapServersUtils.addZipFile(action, gs, f.getPath(), resource, metadataUuid, metadataTitle, metadataAbstract);
            return string;
        }
    }
}

