/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.doiservers.model;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.DoiServer;
import org.fao.geonet.domain.Group;
import org.fao.geonet.repository.GroupRepository;

public class DoiServerDto {
    private int id;
    private String name;
    private String description;
    private String url;
    private String username;
    private String password;
    private String landingPageTemplate;
    private String publicUrl;
    private String pattern = "{{uuid}}";
    private String prefix;
    private Set<Integer> publicationGroups = new HashSet<Integer>();

    public int getId() {
        return this.id;
    }

    public DoiServerDto setId(int id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DoiServerDto setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public DoiServerDto setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public DoiServerDto setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public DoiServerDto setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public DoiServerDto setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getLandingPageTemplate() {
        return this.landingPageTemplate;
    }

    public DoiServerDto setLandingPageTemplate(String landingPageTemplate) {
        this.landingPageTemplate = landingPageTemplate;
        return this;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public DoiServerDto setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public DoiServerDto setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public DoiServerDto setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public Set<Integer> getPublicationGroups() {
        return this.publicationGroups;
    }

    public DoiServerDto setPublicationGroups(Set<Integer> publicationGroups) {
        this.publicationGroups = publicationGroups;
        return this;
    }

    public static DoiServerDto from(DoiServer doiServer) {
        DoiServerDto doiServerDto = new DoiServerDto();
        doiServerDto.setId(doiServer.getId());
        doiServerDto.setName(doiServer.getName());
        doiServerDto.setDescription(doiServer.getDescription());
        doiServerDto.setUrl(doiServer.getUrl());
        doiServerDto.setUsername(doiServer.getUsername());
        doiServerDto.setPassword(doiServer.getPassword());
        doiServerDto.setPattern(doiServer.getPattern());
        doiServerDto.setLandingPageTemplate(doiServer.getLandingPageTemplate());
        doiServerDto.setPublicUrl(doiServer.getPublicUrl());
        doiServerDto.setPrefix(doiServer.getPrefix());
        doiServerDto.setPublicationGroups(doiServer.getPublicationGroups().stream().map(Group::getId).collect(Collectors.toSet()));
        return doiServerDto;
    }

    public DoiServer asDoiServer() {
        DoiServer doiServer = new DoiServer();
        doiServer.setId(this.getId());
        doiServer.setName(this.getName());
        doiServer.setDescription(this.getDescription());
        doiServer.setUrl(this.getUrl());
        doiServer.setUsername(this.getUsername());
        doiServer.setPassword(this.getPassword());
        doiServer.setPattern(this.getPattern());
        doiServer.setLandingPageTemplate(this.getLandingPageTemplate());
        doiServer.setPublicUrl(this.getPublicUrl());
        doiServer.setPrefix(this.getPrefix());
        GroupRepository groupRepository = (GroupRepository)ApplicationContextHolder.get().getBean(GroupRepository.class);
        HashSet groups = new HashSet();
        this.getPublicationGroups().forEach(groupId -> {
            Optional g;
            if (groupId != null && (g = groupRepository.findById(groupId)).isPresent()) {
                groups.add((Group)g.get());
            }
        });
        doiServer.setPublicationGroups(groups);
        return doiServer;
    }
}

