/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util;

import org.apache.commons.io.FilenameUtils;
import ro.isdc.wro.util.Transformer;

public class Transformers {
    public static Transformer<String> extensionTransformer(final String newExtension) {
        return new Transformer<String>(){

            @Override
            public String transform(String input) {
                return FilenameUtils.getBaseName((String)input) + "." + newExtension;
            }
        };
    }

    public static Transformer<String> baseNameSuffixTransformer(final String suffix) {
        return new Transformer<String>(){

            @Override
            public String transform(String input) {
                String baseName = FilenameUtils.getBaseName((String)input);
                String extension = FilenameUtils.getExtension((String)input);
                return baseName + suffix + "." + extension;
            }
        };
    }

    public static Transformer<String> noOpTransformer() {
        return new Transformer<String>(){

            @Override
            public String transform(String input) {
                return input;
            }
        };
    }
}

