/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;
import ro.isdc.wro.util.WroUtil;

public class PlaceholderProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PlaceholderProcessor.class);
    private static final Pattern PATTERN_PLACEHOLDER = Pattern.compile(WroUtil.loadRegexpWithKey("placeholder"));
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private ObjectFactory<Properties> propertiesFactory;
    private boolean ignoreMissingVariables = true;

    @Override
    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    @Override
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        Matcher matcher = PATTERN_PLACEHOLDER.matcher(content);
        StringBuffer sb = new StringBuffer();
        Properties properties = null;
        if (this.propertiesFactory != null) {
            properties = this.propertiesFactory.create();
        }
        if (properties == null) {
            properties = EMPTY_PROPERTIES;
        }
        while (matcher.find()) {
            String variableName = matcher.group(1);
            LOG.debug("found placeholder: {}", (Object)variableName);
            matcher.appendReplacement(sb, this.replaceVariable(properties, variableName));
        }
        matcher.appendTail(sb);
        writer.write(sb.toString());
    }

    private String replaceVariable(Properties properties, String variableName) {
        String variableValue = properties.getProperty(variableName);
        if (!this.ignoreMissingVariables && variableValue == null) {
            throw new WroRuntimeException("No value defind for variable called: [" + variableName + "]");
        }
        String result = variableValue == null ? "" : variableValue;
        LOG.debug("replacing: [{}] with [{}]", (Object)variableName, (Object)result);
        return result;
    }

    public PlaceholderProcessor setIgnoreMissingVariables(boolean ignoreMissingVariables) {
        this.ignoreMissingVariables = ignoreMissingVariables;
        return this;
    }

    public PlaceholderProcessor setPropertiesFactory(ObjectFactory<Properties> propertiesFactory) {
        this.propertiesFactory = propertiesFactory;
        return this;
    }
}

