/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.client;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.wmts.client.WMTSTile;
import org.geotools.ows.wmts.client.WMTSTileIdentifier;
import org.geotools.ows.wmts.client.WMTSTileService;
import org.geotools.ows.wmts.client.WMTSZoomLevel;
import org.geotools.ows.wmts.model.TileMatrix;
import org.geotools.ows.wmts.model.TileMatrixLimits;
import org.geotools.ows.wmts.model.TileMatrixSet;
import org.geotools.ows.wmts.model.TileMatrixSetLink;
import org.geotools.tile.Tile;
import org.geotools.tile.TileFactory;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.util.logging.Logging;
import si.uom.NonSI;
import si.uom.SI;

public class WMTSTileFactory
extends TileFactory {
    private static final double PixelSizeMeters = 2.8E-4;
    private static final Logger LOGGER = Logging.getLogger(WMTSTileFactory.class);

    public Tile create(TileIdentifier identifier, TileService service) {
        return new WMTSTile(identifier, service);
    }

    public Tile findTileAtCoordinate(double lon, double lat, ZoomLevel zoomLevel, TileService service) {
        return this.create(service.identifyTileAtCoordinate(lon, lat, zoomLevel), service);
    }

    public Tile findUpperLeftTile(double lon, double lat, WMTSZoomLevel zoomLevel, WMTSTileService service) {
        Tile matrixTile = this.findTileAtCoordinate(lon, lat, zoomLevel, service);
        return this.constrainToUpperLeftTile(matrixTile, zoomLevel, service);
    }

    public static TileMatrixLimits getLimits(TileMatrixSetLink tmsl, TileMatrixSet tms, int z) {
        TileMatrixLimits limits;
        List<TileMatrixLimits> limitsList = tmsl.getLimits();
        if (limitsList != null && z < limitsList.size()) {
            limits = limitsList.get(z);
        } else {
            TileMatrix tileMatrix = tms.getMatrices().get(z);
            limits = new TileMatrixLimits();
            limits.setMinCol(0L);
            limits.setMinRow(0L);
            limits.setMaxCol(tileMatrix.getMatrixWidth() - 1);
            limits.setMaxRow(tileMatrix.getMatrixHeight() - 1);
            limits.setTileMatix(tms.getIdentifier());
        }
        return limits;
    }

    public WMTSTile constrainToUpperLeftTile(Tile matrixTile, WMTSZoomLevel zl, WMTSTileService service) {
        TileMatrixLimits limits = WMTSTileFactory.getLimits(service.getMatrixSetLink(), service.getMatrixSet(), zl.getZoomLevel());
        long origxTile = matrixTile.getTileIdentifier().getX();
        long origyTile = matrixTile.getTileIdentifier().getY();
        long xTile = origxTile;
        long yTile = origyTile;
        if (xTile >= limits.getMaxcol()) {
            xTile = limits.getMaxcol() - 1L;
        }
        if (yTile >= limits.getMaxrow()) {
            yTile = limits.getMaxrow() - 1L;
        }
        if (xTile < limits.getMincol()) {
            xTile = limits.getMincol();
        }
        if (yTile < limits.getMinrow()) {
            yTile = limits.getMinrow();
        }
        if ((origxTile != xTile || origyTile != yTile) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("findUpperLeftTile: constraining tile within limits: (" + origxTile + "," + origyTile + ") -> (" + xTile + "," + yTile + ")");
        }
        return (WMTSTile)this.create(new WMTSTileIdentifier((int)xTile, (int)yTile, zl, service.getName()), service);
    }

    public WMTSZoomLevel getZoomLevel(int zoomLevel, TileService service) {
        return new WMTSZoomLevel(zoomLevel, (WMTSTileService)service);
    }

    public Tile findRightNeighbour(Tile tile, TileService service) {
        WMTSTileIdentifier id = (WMTSTileIdentifier)tile.getTileIdentifier().getRightNeighbour();
        return id == null ? null : this.create(id, service);
    }

    public Tile findLowerNeighbour(Tile tile, TileService service) {
        WMTSTileIdentifier id = (WMTSTileIdentifier)tile.getTileIdentifier().getLowerNeighbour();
        return id == null ? null : this.create(id, service);
    }

    public static ReferencedEnvelope getExtentFromTileName(WMTSTileIdentifier tileIdentifier, TileService service) {
        double tileMatrixMaxY;
        double tileMatrixMinX;
        WMTSZoomLevel zl = new WMTSZoomLevel(tileIdentifier.getZ(), (WMTSTileService)service);
        TileMatrix tileMatrix = ((WMTSTileService)service).getMatrixSet().getMatrices().get(zl.getZoomLevel());
        CoordinateReferenceSystem crs = tileMatrix.getCrs();
        CoordinateSystem coordinateSystem = crs.getCoordinateSystem();
        double pixelSpan = WMTSTileFactory.getPixelSpan(tileMatrix);
        double tileSpanY = (double)tileMatrix.getTileHeight() * pixelSpan;
        double tileSpanX = (double)tileMatrix.getTileWidth() * pixelSpan;
        boolean longFirst = coordinateSystem.getAxis(0).getDirection().equals((Object)AxisDirection.EAST);
        if (longFirst) {
            tileMatrixMinX = tileMatrix.getTopLeft().getX();
            tileMatrixMaxY = tileMatrix.getTopLeft().getY();
        } else {
            tileMatrixMaxY = tileMatrix.getTopLeft().getX();
            tileMatrixMinX = tileMatrix.getTopLeft().getY();
        }
        ReferencedEnvelope ret = new ReferencedEnvelope(crs);
        double minX = (double)tileIdentifier.getX() * tileSpanX + tileMatrixMinX;
        double maxY = tileMatrixMaxY - (double)tileIdentifier.getY() * tileSpanY;
        double maxX = minX + tileSpanX;
        double minY = maxY - tileSpanY;
        if (longFirst) {
            ret.expandToInclude(minX, minY);
            ret.expandToInclude(maxX, maxY);
        } else {
            ret.expandToInclude(minY, minX);
            ret.expandToInclude(maxY, maxX);
        }
        return ret;
    }

    static double getPixelSpan(TileMatrix tileMatrix) {
        CoordinateSystem coordinateSystem = tileMatrix.getCrs().getCoordinateSystem();
        Unit unit = coordinateSystem.getAxis(0).getUnit();
        double pixelSpan = tileMatrix.getDenominator() * 2.8E-4;
        if (unit.equals(NonSI.DEGREE_ANGLE)) {
            pixelSpan /= 111319.0;
        } else {
            UnitConverter metersperunit = unit.getConverterTo(SI.METRE);
            pixelSpan /= metersperunit.convert(1.0);
        }
        return pixelSpan;
    }
}

