/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.warp.WarpOpImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationTable;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.Warp;
import javax.media.jai.iterator.RandomIter;

final class WarpBicubicOpImage
extends WarpOpImage {
    private static final int KERNEL_LINE_DIM = 4;
    protected static final int USHORT_MAX_VALUE = 65535;
    private byte[][] ctable = null;
    private boolean[] booleanLookupTable;
    private int[] dataHi;
    private int[] dataVi;
    private float[] dataHf;
    private float[] dataVf;
    private double[] dataHd;
    private double[] dataVd;
    private int shift;
    private int round;
    private int precisionBits;

    public WarpBicubicOpImage(RenderedImage source, BorderExtender extender, Map<?, ?> config, ImageLayout layout, Warp warp, Interpolation interp, ROI sourceROI, Range noData, double[] bkg) {
        super(source, layout, config, false, extender, interp, warp, bkg, sourceROI, noData);
        SampleModel sm;
        int srcDataType;
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)srcColorModel;
            this.ctable = new byte[icm.getNumComponents() == 4 ? 4 : 3][icm.getMapSize()];
            icm.getReds(this.ctable[0]);
            icm.getGreens(this.ctable[1]);
            icm.getBlues(this.ctable[2]);
            if (icm.getNumComponents() == 4) {
                icm.getAlphas(this.ctable[3]);
            }
        }
        if ((srcDataType = (sm = source.getSampleModel()).getDataType()) == 0 && this.hasNoData) {
            this.booleanLookupTable = new boolean[256];
            for (int i = 0; i < this.booleanLookupTable.length; ++i) {
                byte value = (byte)i;
                this.booleanLookupTable[i] = this.noDataRange.contains(value);
            }
        }
        InterpolationTable interpCubic = (InterpolationTable)interp;
        switch (srcDataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.dataHi = interpCubic.getHorizontalTableData();
                this.dataVi = interpCubic.getVerticalTableData();
                break;
            }
            case 4: {
                this.dataHf = interpCubic.getHorizontalTableDataFloat();
                this.dataVf = interpCubic.getVerticalTableDataFloat();
                break;
            }
            case 5: {
                this.dataHd = interpCubic.getHorizontalTableDataDouble();
                this.dataVd = interpCubic.getVerticalTableDataDouble();
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data Type");
            }
        }
        this.shift = 1 << interp.getSubsampleBitsH();
        this.precisionBits = interpCubic.getPrecisionBits();
        if (this.precisionBits > 0) {
            this.round = 1 << this.precisionBits - 1;
        }
        this.leftPad = 1;
        this.rightPad = 2;
        this.topPad = 1;
        this.bottomPad = 2;
    }

    @Override
    protected void computeRectByte(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iterSource;
        if (this.extended) {
            iterSource = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iterSource = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        byte[][] data = dst.getByteDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.hasROI && !roiContainsTile && roiIter == null) {
            throw new IllegalArgumentException("Error on creating the ROI iterator");
        }
        if (this.ctable == null) {
            if (this.caseA || this.caseB && roiContainsTile) {
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBicubicOpImage.floor(sx);
                        int yint = WarpBicubicOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (int b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            int offsetX = 4 * (int)((float)this.shift * xfrac);
                            int offsetY = 4 * (int)((float)this.shift * yfrac);
                            for (int b = 0; b < dstBands; ++b) {
                                long result = this.bicubicCalculationInt(b, iterSource, xint, yint, offsetX, offsetY, null);
                                if (result > 255L) {
                                    result = 255L;
                                } else if (result < 0L) {
                                    result = 0L;
                                }
                                data[b][pixelOffset + bandOffsets[b]] = (byte)(result & 0xFFL);
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else if (this.caseB) {
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBicubicOpImage.floor(sx);
                        int yint = WarpBicubicOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (int b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            int b;
                            int offsetX = 4 * (int)((float)this.shift * xfrac);
                            int offsetY = 4 * (int)((float)this.shift * yfrac);
                            boolean inRoi = false;
                            for (int j = 0; j < 4 && !inRoi; ++j) {
                                for (int i = 0; i < 4 && !inRoi; ++i) {
                                    int x = xint + (i - 1);
                                    int y = yint + (j - 1);
                                    if (!this.roiBounds.contains(x, y)) continue;
                                    inRoi |= roiIter.getSample(x, y, 0) > 0;
                                }
                            }
                            if (inRoi) {
                                for (b = 0; b < dstBands; ++b) {
                                    long result = this.bicubicCalculationInt(b, iterSource, xint, yint, offsetX, offsetY, null);
                                    if (result > 255L) {
                                        result = 255L;
                                    } else if (result < 0L) {
                                        result = 0L;
                                    }
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)(result & 0xFFL);
                                }
                            } else {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
                long[][] pixelKernel = new long[4][4];
                long[] sumArray = new long[4];
                long[] emptyArray = new long[4];
                int weight = 0;
                int weightVert = 0;
                byte temp = 0;
                long tempSum = 0L;
                long sum = 0L;
                long result = 0L;
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBicubicOpImage.floor(sx);
                        int yint = WarpBicubicOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (int b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            int offsetX = 4 * (int)((float)this.shift * xfrac);
                            int offsetY = 4 * (int)((float)this.shift * yfrac);
                            for (int b = 0; b < dstBands; ++b) {
                                long[] tempData;
                                for (int j = 0; j < 4; ++j) {
                                    for (int i = 0; i < 4; ++i) {
                                        int sample = iterSource.getSample(xint + (i - 1), yint + (j - 1), b) & 0xFF;
                                        pixelKernel[j][i] = sample;
                                        weight = this.booleanLookupTable[sample] ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                    }
                                    temp = (byte)(weight >> 4 * j & 0xF);
                                    tempData = WarpBicubicOpImage.bicubicInpainting(pixelKernel[j], temp, emptyArray);
                                    tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                    sumArray[j] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                if (weight == 0) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                    continue;
                                }
                                tempData = WarpBicubicOpImage.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                                result = sum + (long)this.round >> this.precisionBits;
                                weight = 0;
                                weightVert = 0;
                                sum = 0L;
                                result = InterpolationBicubic.clampAndFixOvershootingByte((int)((int)result), (byte)((byte)this.backgroundValues[b]));
                                data[b][pixelOffset + bandOffsets[b]] = (byte)(result & 0xFFL);
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else {
                long[][] pixelKernel = new long[4][4];
                long[] sumArray = new long[4];
                long[] emptyArray = new long[4];
                int weight = 0;
                int weightVert = 0;
                byte temp = 0;
                long tempSum = 0L;
                long sum = 0L;
                long result = 0L;
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBicubicOpImage.floor(sx);
                        int yint = WarpBicubicOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (int b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            int b;
                            int offsetX = 4 * (int)((float)this.shift * xfrac);
                            int offsetY = 4 * (int)((float)this.shift * yfrac);
                            boolean inRoi = false;
                            for (int j = 0; j < 4 && !inRoi; ++j) {
                                for (int i = 0; i < 4 && !inRoi; ++i) {
                                    int x = xint + (i - 1);
                                    int y = yint + (j - 1);
                                    if (!this.roiBounds.contains(x, y)) continue;
                                    inRoi |= roiIter.getSample(x, y, 0) > 0;
                                }
                            }
                            if (inRoi) {
                                for (b = 0; b < dstBands; ++b) {
                                    long[] tempData;
                                    for (int j = 0; j < 4; ++j) {
                                        for (int i = 0; i < 4; ++i) {
                                            int sample = iterSource.getSample(xint + (i - 1), yint + (j - 1), b) & 0xFF;
                                            pixelKernel[j][i] = sample;
                                            weight = this.booleanLookupTable[sample] ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                        }
                                        temp = (byte)(weight >> 4 * j & 0xF);
                                        tempData = WarpBicubicOpImage.bicubicInpainting(pixelKernel[j], temp, emptyArray);
                                        tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                        weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                        sumArray[j] = tempSum + (long)this.round >> this.precisionBits;
                                    }
                                    if (weight == 0) {
                                        data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                        continue;
                                    }
                                    tempData = WarpBicubicOpImage.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                    sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                                    result = sum + (long)this.round >> this.precisionBits;
                                    weight = 0;
                                    weightVert = 0;
                                    sum = 0L;
                                    if (result > 255L) {
                                        result = 255L;
                                    } else if (result < 0L) {
                                        result = 0L;
                                    }
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)(result & 0xFFL);
                                }
                            } else {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            }
        } else if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            byte[] t = this.ctable[b];
                            long result = this.bicubicCalculationInt(b, iterSource, xint, yint, offsetX, offsetY, t);
                            if (result > 255L) {
                                result = 255L;
                            } else if (result < 0L) {
                                result = 0L;
                            }
                            data[b][pixelOffset + bandOffsets[b]] = (byte)(result & 0xFFL);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                byte[] t = this.ctable[b];
                                long result = this.bicubicCalculationInt(b, iterSource, xint, yint, offsetX, offsetY, t);
                                if (result > 255L) {
                                    result = 255L;
                                } else if (result < 0L) {
                                    result = 0L;
                                }
                                data[b][pixelOffset + bandOffsets[b]] = (byte)(result & 0xFFL);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            long[] tempData;
                            byte[] t = this.ctable[b];
                            for (int j = 0; j < 4; ++j) {
                                for (int i = 0; i < 4; ++i) {
                                    int sample = t[iterSource.getSample(xint + (i - 1), yint + (j - 1), 0) & 0xFF] & 0xFF;
                                    pixelKernel[j][i] = sample;
                                    weight = this.booleanLookupTable[sample] ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                }
                                temp = (byte)(weight >> 4 * j & 0xF);
                                tempData = WarpBicubicOpImage.bicubicInpainting(pixelKernel[j], temp, emptyArray);
                                tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                sumArray[j] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            if (weight == 0) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                continue;
                            }
                            tempData = WarpBicubicOpImage.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            result = sum + (long)this.round >> this.precisionBits;
                            weight = 0;
                            weightVert = 0;
                            sum = 0L;
                            result = InterpolationBicubic.clampAndFixOvershootingByte((int)((int)result), (byte)((byte)this.backgroundValues[b]));
                            data[b][pixelOffset + bandOffsets[b]] = (byte)(result & 0xFFL);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                long[] tempData;
                                byte[] t = this.ctable[b];
                                for (int j = 0; j < 4; ++j) {
                                    for (int i = 0; i < 4; ++i) {
                                        int sample = t[iterSource.getSample(xint + (i - 1), yint + (j - 1), 0) & 0xFF] & 0xFF;
                                        pixelKernel[j][i] = sample;
                                        weight = this.booleanLookupTable[sample] ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                    }
                                    temp = (byte)(weight >> 4 * j & 0xF);
                                    tempData = WarpBicubicOpImage.bicubicInpainting(pixelKernel[j], temp, emptyArray);
                                    tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                    sumArray[j] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                if (weight == 0) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                    continue;
                                }
                                tempData = WarpBicubicOpImage.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                                result = sum + (long)this.round >> this.precisionBits;
                                weight = 0;
                                weightVert = 0;
                                sum = 0L;
                                result = InterpolationBicubic.clampAndFixOvershootingByte((int)((int)result), (byte)((byte)this.backgroundValues[b]));
                                data[b][pixelOffset + bandOffsets[b]] = (byte)(result & 0xFFL);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectUShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iterSource;
        if (this.extended) {
            iterSource = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iterSource = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.hasROI && !roiContainsTile && roiIter == null) {
            throw new IllegalArgumentException("Error on creating the ROI iterator");
        }
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            long result = this.bicubicCalculationInt(b, iterSource, xint, yint, offsetX, offsetY, null);
                            if (result > 65535L) {
                                result = 65535L;
                            } else if (result < 0L) {
                                result = 0L;
                            }
                            data[b][pixelOffset + bandOffsets[b]] = (short)(result & 0xFFFFL);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                long result = this.bicubicCalculationInt(b, iterSource, xint, yint, offsetX, offsetY, null);
                                if (result > 65535L) {
                                    result = 65535L;
                                } else if (result < 0L) {
                                    result = 0L;
                                }
                                data[b][pixelOffset + bandOffsets[b]] = (short)(result & 0xFFFFL);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            long[] tempData;
                            for (int j = 0; j < 4; ++j) {
                                for (int i = 0; i < 4; ++i) {
                                    int sample = iterSource.getSample(xint + (i - 1), yint + (j - 1), b) & 0xFFFF;
                                    pixelKernel[j][i] = sample;
                                    weight = this.noDataRange.contains((short)sample) ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                }
                                temp = (byte)(weight >> 4 * j & 0xF);
                                tempData = WarpBicubicOpImage.bicubicInpainting(pixelKernel[j], temp, emptyArray);
                                tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                sumArray[j] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            if (weight == 0) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                                continue;
                            }
                            tempData = WarpBicubicOpImage.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            result = sum + (long)this.round >> this.precisionBits;
                            weight = 0;
                            weightVert = 0;
                            sum = 0L;
                            result = InterpolationBicubic.clampAndFixOvershootingUShort((int)((int)result), (short)((short)this.backgroundValues[b]));
                            data[b][pixelOffset + bandOffsets[b]] = (short)(result & 0xFFFFL);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                long[] tempData;
                                for (int j = 0; j < 4; ++j) {
                                    for (int i = 0; i < 4; ++i) {
                                        int sample = iterSource.getSample(xint + (i - 1), yint + (j - 1), b) & 0xFFFF;
                                        pixelKernel[j][i] = sample;
                                        weight = this.noDataRange.contains((short)sample) ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                    }
                                    temp = (byte)(weight >> 4 * j & 0xF);
                                    tempData = WarpBicubicOpImage.bicubicInpainting(pixelKernel[j], temp, emptyArray);
                                    tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                    sumArray[j] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                if (weight == 0) {
                                    data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                                    continue;
                                }
                                tempData = WarpBicubicOpImage.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                                result = sum + (long)this.round >> this.precisionBits;
                                weight = 0;
                                weightVert = 0;
                                sum = 0L;
                                result = InterpolationBicubic.clampAndFixOvershootingUShort((int)((int)result), (short)((short)this.backgroundValues[b]));
                                data[b][pixelOffset + bandOffsets[b]] = (short)(result & 0xFFFFL);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iterSource;
        if (this.extended) {
            iterSource = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iterSource = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.hasROI && !roiContainsTile && roiIter == null) {
            throw new IllegalArgumentException("Error on creating the ROI iterator");
        }
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            long result = this.bicubicCalculationInt(b, iterSource, xint, yint, offsetX, offsetY, null);
                            if (result > 32767L) {
                                result = 32767L;
                            } else if (result < -32768L) {
                                result = -32768L;
                            }
                            data[b][pixelOffset + bandOffsets[b]] = (short)result;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                long result = this.bicubicCalculationInt(b, iterSource, xint, yint, offsetX, offsetY, null);
                                if (result > 32767L) {
                                    result = 32767L;
                                } else if (result < -32768L) {
                                    result = -32768L;
                                }
                                data[b][pixelOffset + bandOffsets[b]] = (short)result;
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            long[] tempData;
                            for (int j = 0; j < 4; ++j) {
                                for (int i = 0; i < 4; ++i) {
                                    int sample = iterSource.getSample(xint + (i - 1), yint + (j - 1), b);
                                    pixelKernel[j][i] = sample;
                                    weight = this.noDataRange.contains((short)sample) ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                }
                                temp = (byte)(weight >> 4 * j & 0xF);
                                tempData = WarpBicubicOpImage.bicubicInpainting(pixelKernel[j], temp, emptyArray);
                                tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                sumArray[j] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            if (weight == 0) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                                continue;
                            }
                            tempData = WarpBicubicOpImage.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            result = sum + (long)this.round >> this.precisionBits;
                            weight = 0;
                            weightVert = 0;
                            sum = 0L;
                            if (result > 32767L) {
                                result = 32767L;
                            } else if (result < -32768L) {
                                result = -32768L;
                            }
                            data[b][pixelOffset + bandOffsets[b]] = (short)result;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                long[] tempData;
                                for (int j = 0; j < 4; ++j) {
                                    for (int i = 0; i < 4; ++i) {
                                        int sample = iterSource.getSample(xint + (i - 1), yint + (j - 1), b);
                                        pixelKernel[j][i] = sample;
                                        weight = this.noDataRange.contains((short)sample) ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                    }
                                    temp = (byte)(weight >> 4 * j & 0xF);
                                    tempData = WarpBicubicOpImage.bicubicInpainting(pixelKernel[j], temp, emptyArray);
                                    tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                    sumArray[j] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                if (weight == 0) {
                                    data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                                    continue;
                                }
                                tempData = WarpBicubicOpImage.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                                result = sum + (long)this.round >> this.precisionBits;
                                weight = 0;
                                weightVert = 0;
                                sum = 0L;
                                if (result > 32767L) {
                                    result = 32767L;
                                } else if (result < -32768L) {
                                    result = -32768L;
                                }
                                data[b][pixelOffset + bandOffsets[b]] = (short)result;
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectInt(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iterSource;
        if (this.extended) {
            iterSource = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iterSource = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        int[][] data = dst.getIntDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.hasROI && !roiContainsTile && roiIter == null) {
            throw new IllegalArgumentException("Error on creating the ROI iterator");
        }
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            long result = this.bicubicCalculationInt(b, iterSource, xint, yint, offsetX, offsetY, null);
                            if (result > Integer.MAX_VALUE) {
                                result = Integer.MAX_VALUE;
                            } else if (result < Integer.MIN_VALUE) {
                                result = Integer.MIN_VALUE;
                            }
                            data[b][pixelOffset + bandOffsets[b]] = (int)result;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                long result = this.bicubicCalculationInt(b, iterSource, xint, yint, offsetX, offsetY, null);
                                if (result > Integer.MAX_VALUE) {
                                    result = Integer.MAX_VALUE;
                                } else if (result < Integer.MIN_VALUE) {
                                    result = Integer.MIN_VALUE;
                                }
                                data[b][pixelOffset + bandOffsets[b]] = (int)result;
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            long[] tempData;
                            for (int j = 0; j < 4; ++j) {
                                for (int i = 0; i < 4; ++i) {
                                    int sample = iterSource.getSample(xint + (i - 1), yint + (j - 1), b);
                                    pixelKernel[j][i] = sample;
                                    weight = this.noDataRange.contains(sample) ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                }
                                temp = (byte)(weight >> 4 * j & 0xF);
                                tempData = WarpBicubicOpImage.bicubicInpainting(pixelKernel[j], temp, emptyArray);
                                tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                sumArray[j] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            if (weight == 0) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                                continue;
                            }
                            tempData = WarpBicubicOpImage.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            result = sum + (long)this.round >> this.precisionBits;
                            weight = 0;
                            weightVert = 0;
                            sum = 0L;
                            if (result > Integer.MAX_VALUE) {
                                result = Integer.MAX_VALUE;
                            } else if (result < Integer.MIN_VALUE) {
                                result = Integer.MIN_VALUE;
                            }
                            data[b][pixelOffset + bandOffsets[b]] = (int)result;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                long[] tempData;
                                for (int j = 0; j < 4; ++j) {
                                    for (int i = 0; i < 4; ++i) {
                                        int sample = iterSource.getSample(xint + (i - 1), yint + (j - 1), b);
                                        pixelKernel[j][i] = sample;
                                        weight = this.noDataRange.contains(sample) ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                    }
                                    temp = (byte)(weight >> 4 * j & 0xF);
                                    tempData = WarpBicubicOpImage.bicubicInpainting(pixelKernel[j], temp, emptyArray);
                                    tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                    sumArray[j] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                if (weight == 0) {
                                    data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                                    continue;
                                }
                                tempData = WarpBicubicOpImage.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                                result = sum + (long)this.round >> this.precisionBits;
                                weight = 0;
                                weightVert = 0;
                                sum = 0L;
                                if (result > Integer.MAX_VALUE) {
                                    result = Integer.MAX_VALUE;
                                } else if (result < Integer.MIN_VALUE) {
                                    result = Integer.MIN_VALUE;
                                }
                                data[b][pixelOffset + bandOffsets[b]] = (int)result;
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectFloat(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iterSource;
        if (this.extended) {
            iterSource = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iterSource = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        float[][] data = dst.getFloatDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.hasROI && !roiContainsTile && roiIter == null) {
            throw new IllegalArgumentException("Error on creating the ROI iterator");
        }
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            double result = this.bicubicCalculationFloat(b, iterSource, xint, yint, offsetX, offsetY);
                            if (result > 3.4028234663852886E38) {
                                result = 3.4028234663852886E38;
                            } else if (result < -3.4028234663852886E38) {
                                result = -3.4028234663852886E38;
                            }
                            data[b][pixelOffset + bandOffsets[b]] = (float)result;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                double result = this.bicubicCalculationFloat(b, iterSource, xint, yint, offsetX, offsetY);
                                if (result > 3.4028234663852886E38) {
                                    result = 3.4028234663852886E38;
                                } else if (result < -3.4028234663852886E38) {
                                    result = -3.4028234663852886E38;
                                }
                                data[b][pixelOffset + bandOffsets[b]] = (float)result;
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            double tempSum = 0.0;
            double sum = 0.0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            double[] tempData;
                            for (int j = 0; j < 4; ++j) {
                                for (int i = 0; i < 4; ++i) {
                                    float sample = iterSource.getSampleFloat(xint + (i - 1), yint + (j - 1), b);
                                    pixelKernel[j][i] = sample;
                                    weight = this.noDataRange.contains(sample) ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                }
                                temp = (byte)(weight >> 4 * j & 0xF);
                                tempData = WarpBicubicOpImage.bicubicInpaintingDouble(pixelKernel[j], temp, emptyArray);
                                tempSum = tempData[0] * (double)this.dataHf[offsetX] + tempData[1] * (double)this.dataHf[offsetX + 1] + tempData[2] * (double)this.dataHf[offsetX + 2] + tempData[3] * (double)this.dataHf[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                sumArray[j] = tempSum;
                            }
                            if (weight == 0) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                                continue;
                            }
                            tempData = WarpBicubicOpImage.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            sum = tempData[0] * (double)this.dataVf[offsetY] + tempData[1] * (double)this.dataVf[offsetY + 1] + tempData[2] * (double)this.dataVf[offsetY + 2] + tempData[3] * (double)this.dataVf[offsetY + 3];
                            weight = 0;
                            weightVert = 0;
                            if (sum > 3.4028234663852886E38) {
                                sum = 3.4028234663852886E38;
                            } else if (sum < -3.4028234663852886E38) {
                                sum = -3.4028234663852886E38;
                            }
                            data[b][pixelOffset + bandOffsets[b]] = (float)sum;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            double tempSum = 0.0;
            double sum = 0.0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                double[] tempData;
                                for (int j = 0; j < 4; ++j) {
                                    for (int i = 0; i < 4; ++i) {
                                        float sample = iterSource.getSampleFloat(xint + (i - 1), yint + (j - 1), b);
                                        pixelKernel[j][i] = sample;
                                        weight = this.noDataRange.contains(sample) ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                    }
                                    temp = (byte)(weight >> 4 * j & 0xF);
                                    tempData = WarpBicubicOpImage.bicubicInpaintingDouble(pixelKernel[j], temp, emptyArray);
                                    tempSum = tempData[0] * (double)this.dataHf[offsetX] + tempData[1] * (double)this.dataHf[offsetX + 1] + tempData[2] * (double)this.dataHf[offsetX + 2] + tempData[3] * (double)this.dataHf[offsetX + 3];
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                    sumArray[j] = tempSum;
                                }
                                if (weight == 0) {
                                    data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                                    continue;
                                }
                                tempData = WarpBicubicOpImage.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                                sum = tempData[0] * (double)this.dataVf[offsetY] + tempData[1] * (double)this.dataVf[offsetY + 1] + tempData[2] * (double)this.dataVf[offsetY + 2] + tempData[3] * (double)this.dataVf[offsetY + 3];
                                weight = 0;
                                weightVert = 0;
                                if (sum > 3.4028234663852886E38) {
                                    sum = 3.4028234663852886E38;
                                } else if (sum < -3.4028234663852886E38) {
                                    sum = -3.4028234663852886E38;
                                }
                                data[b][pixelOffset + bandOffsets[b]] = (float)sum;
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectDouble(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iterSource;
        if (this.extended) {
            iterSource = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iterSource = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        double[][] data = dst.getDoubleDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.hasROI && !roiContainsTile && roiIter == null) {
            throw new IllegalArgumentException("Error on creating the ROI iterator");
        }
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = this.bicubicCalculationDouble(b, iterSource, xint, yint, offsetX, offsetY);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.bicubicCalculationDouble(b, iterSource, xint, yint, offsetX, offsetY);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            double tempSum = 0.0;
            double sum = 0.0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        for (int b = 0; b < dstBands; ++b) {
                            double[] tempData;
                            for (int j = 0; j < 4; ++j) {
                                for (int i = 0; i < 4; ++i) {
                                    double sample;
                                    pixelKernel[j][i] = sample = iterSource.getSampleDouble(xint + (i - 1), yint + (j - 1), b);
                                    weight = this.noDataRange.contains(sample) ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                }
                                temp = (byte)(weight >> 4 * j & 0xF);
                                tempData = WarpBicubicOpImage.bicubicInpaintingDouble(pixelKernel[j], temp, emptyArray);
                                tempSum = tempData[0] * this.dataHd[offsetX] + tempData[1] * this.dataHd[offsetX + 1] + tempData[2] * this.dataHd[offsetX + 2] + tempData[3] * this.dataHd[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                sumArray[j] = tempSum;
                            }
                            if (weight == 0) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                                continue;
                            }
                            tempData = WarpBicubicOpImage.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            sum = tempData[0] * this.dataVd[offsetY] + tempData[1] * this.dataVd[offsetY + 1] + tempData[2] * this.dataVd[offsetY + 2] + tempData[3] * this.dataVd[offsetY + 3];
                            weight = 0;
                            weightVert = 0;
                            data[b][pixelOffset + bandOffsets[b]] = (float)sum;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            double tempSum = 0.0;
            double sum = 0.0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBicubicOpImage.floor(sx);
                    int yint = WarpBicubicOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        int offsetX = 4 * (int)((float)this.shift * xfrac);
                        int offsetY = 4 * (int)((float)this.shift * yfrac);
                        boolean inRoi = false;
                        for (int j = 0; j < 4 && !inRoi; ++j) {
                            for (int i = 0; i < 4 && !inRoi; ++i) {
                                int x = xint + (i - 1);
                                int y = yint + (j - 1);
                                if (!this.roiBounds.contains(x, y)) continue;
                                inRoi |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (inRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                double[] tempData;
                                for (int j = 0; j < 4; ++j) {
                                    for (int i = 0; i < 4; ++i) {
                                        double sample;
                                        pixelKernel[j][i] = sample = iterSource.getSampleDouble(xint + (i - 1), yint + (j - 1), b);
                                        weight = this.noDataRange.contains(sample) ? (int)((short)(weight & 65535 - (1 << 4 * j + i))) : (int)((short)(weight | 1 << 4 * j + i));
                                    }
                                    temp = (byte)(weight >> 4 * j & 0xF);
                                    tempData = WarpBicubicOpImage.bicubicInpaintingDouble(pixelKernel[j], temp, emptyArray);
                                    tempSum = tempData[0] * this.dataHd[offsetX] + tempData[1] * this.dataHd[offsetX + 1] + tempData[2] * this.dataHd[offsetX + 2] + tempData[3] * this.dataHd[offsetX + 3];
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << j)) : (int)((byte)(weightVert & 15 - (1 << j)));
                                    sumArray[j] = tempSum;
                                }
                                if (weight == 0) {
                                    data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                                    continue;
                                }
                                tempData = WarpBicubicOpImage.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                                sum = tempData[0] * this.dataVd[offsetY] + tempData[1] * this.dataVd[offsetY + 1] + tempData[2] * this.dataVd[offsetY + 2] + tempData[3] * this.dataVd[offsetY + 3];
                                weight = 0;
                                weightVert = 0;
                                data[b][pixelOffset + bandOffsets[b]] = sum;
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    private long bicubicCalculationInt(int b, RandomIter iterSource, int xint, int yint, int offsetX, int offsetY, byte[] t) {
        long sum = 0L;
        if (t == null) {
            for (int j = 0; j < 4; ++j) {
                long temp = 0L;
                for (int i = 0; i < 4; ++i) {
                    int pixelValue = iterSource.getSample(xint + (i - 1), yint + (j - 1), b);
                    temp += (long)(pixelValue * this.dataHi[offsetX + i]);
                }
                sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + j];
            }
        } else {
            for (int j = 0; j < 4; ++j) {
                long temp = 0L;
                for (int i = 0; i < 4; ++i) {
                    int pixelValue = t[iterSource.getSample(xint + (i - 1), yint + (j - 1), 0) & 0xFF] & 0xFF;
                    temp += (long)(pixelValue * this.dataHi[offsetX + i]);
                }
                sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + j];
            }
        }
        return sum + (long)this.round >> this.precisionBits;
    }

    private double bicubicCalculationFloat(int b, RandomIter iterSource, int xint, int yint, int offsetX, int offsetY) {
        double sum = 0.0;
        for (int j = 0; j < 4; ++j) {
            double temp = 0.0;
            for (int i = 0; i < 4; ++i) {
                float pixelValue = iterSource.getSampleFloat(xint + (i - 1), yint + (j - 1), b);
                temp += (double)(pixelValue * this.dataHf[offsetX + i]);
            }
            sum += temp * (double)this.dataVf[offsetY + j];
        }
        return sum;
    }

    private double bicubicCalculationDouble(int b, RandomIter iterSource, int xint, int yint, int offsetX, int offsetY) {
        double sum = 0.0;
        for (int j = 0; j < 4; ++j) {
            double temp = 0.0;
            for (int i = 0; i < 4; ++i) {
                double pixelValue = iterSource.getSampleDouble(xint + (i - 1), yint + (j - 1), b);
                temp += pixelValue * this.dataHd[offsetX + i];
            }
            sum += temp * this.dataVd[offsetY + j];
        }
        return sum;
    }

    private static long[] bicubicInpainting(long[] array, short weightSum, long[] emptyArray) {
        if (weightSum == 15) {
            return array;
        }
        long s_ = array[0];
        long s0 = array[1];
        long s1 = array[2];
        long s2 = array[3];
        emptyArray[0] = 0L;
        emptyArray[1] = 0L;
        emptyArray[2] = 0L;
        emptyArray[3] = 0L;
        switch (weightSum) {
            case 0: {
                break;
            }
            case 1: {
                emptyArray[0] = s_;
                emptyArray[1] = s_;
                emptyArray[2] = s_;
                emptyArray[3] = s_;
                break;
            }
            case 2: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 3: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 4: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 5: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2L;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 6: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 7: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 8: {
                emptyArray[0] = s2;
                emptyArray[1] = s2;
                emptyArray[2] = s2;
                emptyArray[3] = s2;
                break;
            }
            case 9: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s2) / 2L;
                emptyArray[2] = (s_ + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 10: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 11: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 12: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 13: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2L;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 14: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Array cannot be composed from more than 4 elements");
            }
        }
        return emptyArray;
    }

    private static double[] bicubicInpaintingDouble(double[] array, short weightSum, double[] emptyArray) {
        if (weightSum == 15) {
            return array;
        }
        double s_ = array[0];
        double s0 = array[1];
        double s1 = array[2];
        double s2 = array[3];
        emptyArray[0] = 0.0;
        emptyArray[1] = 0.0;
        emptyArray[2] = 0.0;
        emptyArray[3] = 0.0;
        switch (weightSum) {
            case 0: {
                break;
            }
            case 1: {
                emptyArray[0] = s_;
                emptyArray[1] = s_;
                emptyArray[2] = s_;
                emptyArray[3] = s_;
                break;
            }
            case 2: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 3: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 4: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 5: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2.0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 6: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 7: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 8: {
                emptyArray[0] = s2;
                emptyArray[1] = s2;
                emptyArray[2] = s2;
                emptyArray[3] = s2;
                break;
            }
            case 9: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s2) / 2.0;
                emptyArray[2] = (s_ + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 10: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 11: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 12: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 13: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2.0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 14: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Array cannot be composed from more than 4 elements");
            }
        }
        return emptyArray;
    }
}

