/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.NodeConstraintComponent;
import org.apache.jena.shex.expressions.NodeConstraintVisitor;
import org.apache.jena.shex.expressions.ValueSetRange;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.shex.sys.ValidationContext;

public class ValueConstraint
extends NodeConstraintComponent {
    private final List<ValueSetRange> valueSetRanges;

    public ValueConstraint(List<ValueSetRange> valueSetRanges) {
        this.valueSetRanges = valueSetRanges;
    }

    public void forEach(Consumer<ValueSetRange> action) {
        this.valueSetRanges.forEach(action);
    }

    @Override
    public ReportItem nodeSatisfies(ValidationContext vCxt, Node data) {
        boolean b = this.valueSetRanges.stream().anyMatch(valueSetRange -> this.validateRange(vCxt, (ValueSetRange)valueSetRange, data));
        if (!b) {
            return new ReportItem("Value " + ShexLib.displayStr(data) + " not in range: " + this.asString(), null);
        }
        return null;
    }

    private boolean validateRange(ValidationContext vCxt, ValueSetRange valueSetRange, Node data) {
        boolean b1 = valueSetRange.included(data);
        if (!b1) {
            return false;
        }
        boolean b2 = valueSetRange.excluded(data);
        return !b2;
    }

    @Override
    public void print(IndentedWriter out, NodeFormatter nFmt) {
        if (this.valueSetRanges.isEmpty()) {
            out.println("[ ]");
            return;
        }
        out.print("[");
        this.valueSetRanges.forEach((? super T valueSetRange) -> {
            out.print(" ");
            valueSetRange.item.print(out, nFmt);
            if (!valueSetRange.exclusions.isEmpty()) {
                out.print(" -");
                valueSetRange.exclusions.forEach((? super E ex) -> {
                    out.print(" ");
                    ex.print(out, nFmt);
                });
            }
        });
        out.println(" ]");
    }

    @Override
    public void visit(NodeConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "ValueConstraint" + this.asString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.valueSetRanges);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueConstraint other = (ValueConstraint)obj;
        return Objects.equals(this.valueSetRanges, other.valueSetRanges);
    }
}

