/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl.osm;

import org.geotools.tile.TileIdentifier;
import org.geotools.tile.impl.ZoomLevel;

public class OSMTileIdentifier
extends TileIdentifier {
    public OSMTileIdentifier(int x, int y, ZoomLevel zoomLevel, String serviceName) {
        super(x, y, zoomLevel, serviceName);
    }

    @Override
    public String getId() {
        String separator = "_";
        StringBuilder sb = this.createGenericCodeBuilder("_");
        sb.insert(0, "_").insert(0, this.getServiceName());
        return sb.toString();
    }

    @Override
    public String getCode() {
        String separator = "/";
        return this.createGenericCodeBuilder("/").toString();
    }

    private StringBuilder createGenericCodeBuilder(String separator) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.getZ()).append(separator).append(this.getX()).append(separator).append(this.getY());
        return sb;
    }

    @Override
    public TileIdentifier getRightNeighbour() {
        return new OSMTileIdentifier(TileIdentifier.arithmeticMod(this.getX() + 1, this.getZoomLevel().getMaxTilePerRowNumber()), this.getY(), this.getZoomLevel(), this.getServiceName());
    }

    @Override
    public TileIdentifier getLowerNeighbour() {
        return new OSMTileIdentifier(this.getX(), TileIdentifier.arithmeticMod(this.getY() + 1, this.getZoomLevel().getMaxTilePerRowNumber()), this.getZoomLevel(), this.getServiceName());
    }
}

