/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl.osm;

import java.net.URL;
import org.geotools.tile.Tile;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.WebMercatorTileFactory;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.tile.impl.osm.OSMTileIdentifier;

public class OSMTile
extends Tile {
    public static final int DEFAULT_TILE_SIZE = 256;

    public OSMTile(int x, int y, ZoomLevel zoomLevel, TileService service) {
        this(new OSMTileIdentifier(x, y, zoomLevel, service.getName()), service);
    }

    public OSMTile(TileIdentifier tileName, TileService service) {
        super(tileName, WebMercatorTileFactory.getExtentFromTileName(tileName), 256, service);
    }

    @Override
    public URL getUrl() {
        String url = this.service.getBaseUrl() + this.getTileIdentifier().getCode() + ".png";
        try {
            return new URL(url);
        }
        catch (Exception e) {
            String mesg = "Cannot create URL from " + url;
            throw new RuntimeException(mesg, e);
        }
    }
}

