/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.StatementHandler;
import org.openrdf.rio.StatementHandlerException;
import org.openrdf.rio.ntriples.NTriplesParser;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.openrdf.rio.rdfxml.RdfXmlParser;
import org.openrdf.rio.turtle.TurtleParser;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.HtmlAdminMsgWriter;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.AdminResultFormat;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class RemoveStatementsServlet
extends SesameServlet {
    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (HttpServerUtil.isMultipartFormRequest((HttpServletRequest)request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String repository = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"repository");
        String resultFormatStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"resultFormat", (String)AdminResultFormat.XML.toString());
        String subject = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"subject");
        String predicate = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"predicate");
        String object = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"object");
        String data = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"data");
        String baseURI = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"baseURI", (String)"foo:bar");
        String dataFormatStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"dataFormat");
        this._handleRequest(request, response, repository, resultFormatStr, subject, predicate, object, data, baseURI, dataFormatStr);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest((HttpServletRequest)request);
        String repository = HttpServerUtil.getParameter((Map)fileItemMap, (String)"repository");
        String resultFormatStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"resultFormat", (String)AdminResultFormat.XML.toString());
        String subject = HttpServerUtil.getParameter((Map)fileItemMap, (String)"subject");
        String predicate = HttpServerUtil.getParameter((Map)fileItemMap, (String)"predicate");
        String object = HttpServerUtil.getParameter((Map)fileItemMap, (String)"object");
        String data = HttpServerUtil.getParameter((Map)fileItemMap, (String)"data");
        String baseURI = HttpServerUtil.getParameter((Map)fileItemMap, (String)"baseURI", (String)"foo:bar");
        String dataFormatStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"dataFormat");
        this._handleRequest(request, response, repository, resultFormatStr, subject, predicate, object, data, baseURI, dataFormatStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String repository, String resultFormatStr, String subject, String predicate, String object, String data, String baseURI, String dataFormatStr) throws IOException {
        RdfRepository rdfRepository;
        AdminListener adminListener;
        block31: {
            block30: {
                SesameServer.setThreadLogFileForRepository(repository);
                this._logIP(request);
                ThreadLog.log((String)">>> remove statements");
                ThreadLog.trace((String)("repository = " + repository));
                ThreadLog.trace((String)("resultFormat = " + resultFormatStr));
                ThreadLog.trace((String)("subject = " + subject));
                ThreadLog.trace((String)("predicate = " + predicate));
                ThreadLog.trace((String)("object = " + object));
                ThreadLog.trace((String)("data file sent: " + (data != null)));
                ThreadLog.trace((String)("dataFormat = " + dataFormatStr));
                if (repository == null) {
                    this._sendBadRequest("No repository specified", response);
                    return;
                }
                ValueFactoryImpl valFactory = new ValueFactoryImpl();
                Resource subj = null;
                URI pred = null;
                Value obj = null;
                String errMsg = null;
                try {
                    if (subject != null) {
                        errMsg = "Illegal value for subject: " + subject;
                        subj = NTriplesUtil.parseResource((String)subject, (ValueFactory)valFactory);
                    }
                    if (predicate != null) {
                        errMsg = "Illegal value for predicate: " + predicate;
                        pred = NTriplesUtil.parseURI((String)predicate, (ValueFactory)valFactory);
                    }
                    if (object != null) {
                        errMsg = "Illegal value for object: " + object;
                        obj = NTriplesUtil.parseValue((String)object, (ValueFactory)valFactory);
                    }
                }
                catch (IllegalArgumentException e) {
                    this._sendBadRequest(errMsg, response);
                    return;
                }
                HTTPOutputStream httpOut = new HTTPOutputStream(response);
                httpOut.setCacheableResult(false);
                AdminResultFormat resultFormat = AdminResultFormat.forValue(resultFormatStr);
                adminListener = null;
                if (resultFormat == AdminResultFormat.XML) {
                    httpOut.setContentType("text/xml");
                    adminListener = new XmlAdminMsgWriter(httpOut);
                } else {
                    if (resultFormat != AdminResultFormat.HTML) {
                        this._sendBadRequest("Unknown result format: " + resultFormatStr, response);
                        return;
                    }
                    httpOut.setContentType("text/html");
                    adminListener = new HtmlAdminMsgWriter(httpOut);
                }
                rdfRepository = null;
                try {
                    try {
                        LocalService service = SesameServer.getLocalService();
                        this._login(service);
                        LocalRepository localRepository = (LocalRepository)service.getRepository(repository);
                        rdfRepository = (RdfRepository)localRepository.getSail();
                        if (data != null) {
                            if (dataFormatStr == null) {
                                this._sendBadRequest("no data serialization format specified", response);
                                Object var27_26 = null;
                                if (rdfRepository != null && rdfRepository.transactionStarted()) {
                                    rdfRepository.commitTransaction();
                                }
                                adminListener.transactionEnd();
                                return;
                            }
                            RDFFormat dataFormat = RDFFormat.forValue(dataFormatStr);
                            TurtleParser parser = null;
                            if (dataFormat.equals((Object)RDFFormat.TURTLE)) {
                                parser = new TurtleParser();
                            } else if (dataFormat.equals((Object)RDFFormat.RDFXML)) {
                                parser = new RdfXmlParser();
                            } else {
                                if (!dataFormat.equals((Object)RDFFormat.NTRIPLES)) {
                                    this._sendBadRequest("unknown data serialization format: " + dataFormatStr, response);
                                    break block30;
                                }
                                parser = new NTriplesParser();
                            }
                            parser.setStatementHandler((StatementHandler)new StatementRemover(rdfRepository));
                            parser.setParseErrorListener((ParseErrorListener)new ErrorHandler(adminListener));
                            parser.setPreserveBNodeIds(true);
                            StringReader reader = new StringReader(data);
                            rdfRepository.startTransaction();
                            adminListener.transactionStart();
                            parser.parse((Reader)reader, baseURI);
                            break block31;
                        }
                        long startTime = System.currentTimeMillis();
                        localRepository.removeStatements(subj, pred, obj, adminListener);
                        long endTime = System.currentTimeMillis();
                        ThreadLog.trace((String)("removed in " + (endTime - startTime) + "ms"));
                        break block31;
                    }
                    catch (UnknownRepositoryException e) {
                        this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, "Unknown repository: " + repository, response);
                        Object var27_29 = null;
                        if (rdfRepository != null && rdfRepository.transactionStarted()) {
                            rdfRepository.commitTransaction();
                        }
                        adminListener.transactionEnd();
                        return;
                    }
                    catch (AccessDeniedException e) {
                        this._sendForbidden("Access denied", response);
                        Object var27_30 = null;
                        if (rdfRepository != null && rdfRepository.transactionStarted()) {
                            rdfRepository.commitTransaction();
                        }
                        adminListener.transactionEnd();
                        return;
                    }
                    catch (Exception e) {
                        ThreadLog.error((String)("Unknown error on removing RDF data from repository " + repository), (Object)e);
                        adminListener.error("The server generated an unknown error; Please inform the server administrator", -1, -1, null);
                        Object var27_31 = null;
                        if (rdfRepository != null && rdfRepository.transactionStarted()) {
                            rdfRepository.commitTransaction();
                        }
                        adminListener.transactionEnd();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var27_32 = null;
                    if (rdfRepository != null && rdfRepository.transactionStarted()) {
                        rdfRepository.commitTransaction();
                    }
                    adminListener.transactionEnd();
                    throw throwable;
                }
            }
            Object var27_27 = null;
            if (rdfRepository != null && rdfRepository.transactionStarted()) {
                rdfRepository.commitTransaction();
            }
            adminListener.transactionEnd();
            return;
        }
        Object var27_28 = null;
        if (rdfRepository != null && rdfRepository.transactionStarted()) {
            rdfRepository.commitTransaction();
        }
        adminListener.transactionEnd();
    }

    private static class ErrorHandler
    implements ParseErrorListener {
        private int _errorCount = 0;
        private int _statementCount = 0;
        private AdminListener _adminListener;

        public ErrorHandler(AdminListener adminListener) {
            this._adminListener = adminListener;
        }

        public int getErrorCount() {
            return this._errorCount;
        }

        public int getStatementCount() {
            return this._statementCount;
        }

        public void warning(String msg, int lineNo, int colNo) {
            this._adminListener.notification(msg, lineNo, colNo, null);
        }

        public void error(String msg, int lineNo, int colNo) {
            this._adminListener.warning(msg, lineNo, colNo, null);
            ++this._errorCount;
        }

        public void fatalError(String msg, int lineNo, int colNo) {
            this._adminListener.error(msg, lineNo, colNo, null);
            ++this._errorCount;
        }
    }

    private static class StatementRemover
    implements StatementHandler {
        private RdfRepository _rdfRepository;

        public StatementRemover(RdfRepository rdfRepository) {
            this._rdfRepository = rdfRepository;
        }

        public void handleStatement(Resource subject, URI predicate, Value object) throws StatementHandlerException {
            try {
                this._rdfRepository.removeStatements(subject, predicate, object);
            }
            catch (SailUpdateException e) {
                throw new StatementHandlerException((Exception)e);
            }
        }
    }
}

