/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.sailimpl.memory.RdfSourceConfig;

public class RdfRepositoryConfig
extends RdfSourceConfig {
    protected RdfRepositoryConfig(String className, boolean dummy) {
        super(className, true);
    }

    public RdfRepositoryConfig() {
        this("org.openrdf.sesame.sailimpl.memory.RdfRepository", true);
    }

    public RdfRepositoryConfig(String file) {
        this(file, RDFFormat.RDFXML);
    }

    public RdfRepositoryConfig(String file, RDFFormat dataFormat) {
        this();
        this.setFile(file);
        this.setDataFormat(dataFormat);
    }

    public void setCompressFile(boolean compressFile) {
        String compressFileStr = compressFile ? "yes" : "no";
        this.setParameter("compressFile", compressFileStr);
    }

    public boolean getCompressFile() {
        return "yes".equalsIgnoreCase(this.getParameter("compressFile"));
    }

    public void setSyncDelay(long syncDelay) {
        this.setParameter("syncDelay", String.valueOf(syncDelay));
    }

    public long getSyncDelay() {
        String syncDelayStr = this.getParameter("syncDelay");
        if (syncDelayStr != null) {
            return Long.parseLong(syncDelayStr);
        }
        return 0L;
    }
}

