/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils.nio;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.ResolverRewriteDirective;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.nio.PathStreamSource;
import org.jdom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NioPathAwareCatalogResolver
extends CatalogResolver {
    private static final Map<Object, ResolverRewriteDirective> urlRewriteDirectives = Maps.newHashMap();
    private final Set<Path> catalogPaths = Sets.newHashSet();

    public NioPathAwareCatalogResolver(CatalogManager catMan) {
        super(catMan);
        Vector catalogFiles = catMan.getCatalogFiles();
        for (Object catalogFile : catalogFiles) {
            String path = catalogFile.toString();
            if (new File(path).exists() || !Files.exists(IO.toPath(path, new String[0]), new LinkOption[0])) continue;
            try {
                String xml = new String(Files.readAllBytes(IO.toPath(path, new String[0])), Constants.CHARSET);
                Element element = Xml.loadString(xml, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void addRewriteDirective(ResolverRewriteDirective urlRewrite) {
        urlRewriteDirectives.put(urlRewrite.getKey(), urlRewrite);
    }

    public String getResolvedEntity(String publicId, String systemId) {
        return super.getResolvedEntity(publicId, systemId);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        try {
            InputSource inputSource = Xml.PATH_RESOLVER.resolveEntity(publicId, systemId);
            if (inputSource != null) {
                return inputSource;
            }
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        return super.resolveEntity(publicId, systemId);
    }

    public Source resolve(String href, String base) throws TransformerException {
        if (href.startsWith("http")) {
            return super.resolve(href, base);
        }
        for (ResolverRewriteDirective urlRewrite : urlRewriteDirectives.values()) {
            if (!urlRewrite.appliesTo(href)) continue;
            href = urlRewrite.rewrite(href);
            break;
        }
        try {
            Path resolvedResource;
            try {
                resolvedResource = IO.toPath(new URI(href));
                if (Files.isRegularFile(resolvedResource, new LinkOption[0])) {
                    return this.toPathInputSource(resolvedResource);
                }
                SAXSource source = new SAXSource();
                source.setSystemId(href);
                return source;
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                Path basePath = IO.toPath(new URI(base));
                Path parent = basePath.getParent();
                if (parent == null) {
                    throw new RuntimeException(basePath.getFileName() + " does not have parent");
                }
                resolvedResource = parent.resolve(href);
                if (Files.isRegularFile(resolvedResource, new LinkOption[0])) {
                    return this.toPathInputSource(resolvedResource);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.resolve(href, base);
    }

    private PathStreamSource toPathInputSource(Path resolvedResource) {
        PathStreamSource pathInputSource = new PathStreamSource(resolvedResource);
        pathInputSource.setSystemId(resolvedResource.toUri().toASCIIString());
        return pathInputSource;
    }
}

