/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.CharIterator;
import bak.pcj.hash.CharHashFunction;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.map.AbstractCharKeyMap;
import bak.pcj.map.CharKeyMap;
import bak.pcj.map.CharKeyMapIterator;
import bak.pcj.set.AbstractCharSet;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class CharKeyChainedHashMap
extends AbstractCharKeyMap
implements CharKeyMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private CharHashFunction keyhash;
    private int size;
    private transient Entry[] data;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient Set entries;
    private transient CharSet keys;
    private transient Collection values;

    private CharKeyChainedHashMap(CharHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        this.data = new Entry[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
    }

    private CharKeyChainedHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultCharHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public CharKeyChainedHashMap() {
        this(11);
    }

    public CharKeyChainedHashMap(CharKeyMap map) {
        this();
        this.putAll(map);
    }

    public CharKeyChainedHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public CharKeyChainedHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public CharKeyChainedHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public CharKeyChainedHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public CharKeyChainedHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public CharKeyChainedHashMap(CharHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public CharKeyChainedHashMap(CharHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public CharKeyChainedHashMap(CharHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public CharKeyChainedHashMap(CharHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public CharKeyChainedHashMap(CharHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public CharKeyChainedHashMap(CharHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            Entry[] newdata = new Entry[newcapacity];
            int i = 0;
            while (i < this.data.length) {
                Entry e = this.data[i];
                while (e != null) {
                    int index = Math.abs(this.keyhash.hash(e.key)) % newdata.length;
                    Entry next = e.next;
                    e.next = newdata[index];
                    newdata[index] = e;
                    e = next;
                }
                ++i;
            }
            this.data = newdata;
        }
    }

    private Entry addList(Entry list, Entry v) {
        v.next = list;
        return v;
    }

    private Entry removeList(Entry list, Entry e) {
        if (list == e) {
            list = e.next;
            e.next = null;
            return list;
        }
        Entry listStart = list;
        while (list.next != e) {
            list = list.next;
        }
        list.next = e.next;
        e.next = null;
        return listStart;
    }

    private Entry searchList(Entry list, char key) {
        while (list != null) {
            if (list.key == key) {
                return list;
            }
            list = list.next;
        }
        return null;
    }

    private Entry getEntry(char key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        return this.searchList(this.data[index], key);
    }

    public CharSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Object put(char key, Object value) {
        Object result;
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e == null) {
            result = null;
            e = new Entry(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            this.ensureCapacity(this.size + 1);
            ++this.size;
        } else {
            result = e.value;
            e.value = value;
        }
        return result;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public Object clone() {
        try {
            CharKeyChainedHashMap c = (CharKeyChainedHashMap)super.clone();
            c.data = new Entry[this.data.length];
            int i = 0;
            while (i < this.data.length) {
                c.data[i] = this.cloneList(this.data[i]);
                ++i;
            }
            c.values = null;
            c.keys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    private Entry cloneList(Entry e) {
        if (e == null) {
            return null;
        }
        Entry ne = new Entry(e.getKey(), e.getValue());
        ne.next = this.cloneList(e.next);
        return ne;
    }

    public CharKeyMapIterator entries() {
        return new CharKeyMapIterator(){
            Entry currEntry = null;
            int nextList = this.nextList(0);
            Entry nextEntry = this.nextList == -1 ? null : CharKeyChainedHashMap.access$200(CharKeyChainedHashMap.this)[this.nextList];

            int nextList(int index) {
                while (index < CharKeyChainedHashMap.this.data.length && CharKeyChainedHashMap.this.data[index] == null) {
                    ++index;
                }
                return index < CharKeyChainedHashMap.this.data.length ? index : -1;
            }

            public boolean hasNext() {
                return this.nextEntry != null;
            }

            public void next() {
                if (this.nextEntry == null) {
                    Exceptions.endOfIterator();
                }
                this.currEntry = this.nextEntry;
                this.nextEntry = this.nextEntry.next;
                if (this.nextEntry == null) {
                    this.nextList = this.nextList(this.nextList + 1);
                    if (this.nextList != -1) {
                        this.nextEntry = CharKeyChainedHashMap.this.data[this.nextList];
                    }
                }
            }

            public char getKey() {
                if (this.currEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.currEntry.getKey();
            }

            public Object getValue() {
                if (this.currEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.currEntry.getValue();
            }

            public void remove() {
                if (this.currEntry == null) {
                    Exceptions.noElementToRemove();
                }
                CharKeyChainedHashMap.this.remove(this.currEntry.getKey());
                this.currEntry = null;
            }
        };
    }

    public void clear() {
        Arrays.fill(this.data, null);
        this.size = 0;
    }

    public boolean containsKey(char key) {
        Entry e = this.getEntry(key);
        return e != null;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            int i = 0;
            while (i < this.data.length) {
                Entry e = this.data[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.data.length) {
                Entry e = this.data[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
                ++i;
            }
        }
        return false;
    }

    public Object get(char key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        return e != null ? e.value : null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object remove(char key) {
        Object value;
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e != null) {
            this.data[index] = this.removeList(this.data[index], e);
            value = e.value;
            --this.size;
        } else {
            value = null;
        }
        return value;
    }

    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        CharKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeChar(i.getKey());
            s.writeObject(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new Entry[s.readInt()];
        int i = 0;
        while (i < this.size) {
            char key = s.readChar();
            Object value = s.readObject();
            int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
            Entry e = new Entry(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            ++i;
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        public void clear() {
            CharKeyChainedHashMap.this.clear();
        }

        public boolean contains(Object v) {
            return CharKeyChainedHashMap.this.containsValue(v);
        }

        public Iterator iterator() {
            return new Iterator(this){
                Entry currEntry;
                int nextList;
                Entry nextEntry;
                private final /* synthetic */ ValueCollection this$1;
                {
                    this.this$1 = this$1;
                    this.currEntry = null;
                    this.nextList = this.nextList(0);
                    this.nextEntry = this.nextList == -1 ? null : CharKeyChainedHashMap.access$200(ValueCollection.access$600(this.this$1))[this.nextList];
                }

                int nextList(int index) {
                    while (index < CharKeyChainedHashMap.access$200(ValueCollection.access$600(this.this$1)).length && CharKeyChainedHashMap.access$200(ValueCollection.access$600(this.this$1))[index] == null) {
                        ++index;
                    }
                    return index < CharKeyChainedHashMap.access$200(ValueCollection.access$600(this.this$1)).length ? index : -1;
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public Object next() {
                    if (this.nextEntry == null) {
                        Exceptions.endOfIterator();
                    }
                    this.currEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    if (this.nextEntry == null) {
                        this.nextList = this.nextList(this.nextList + 1);
                        if (this.nextList != -1) {
                            this.nextEntry = CharKeyChainedHashMap.access$200(ValueCollection.access$600(this.this$1))[this.nextList];
                        }
                    }
                    return this.currEntry.value;
                }

                public void remove() {
                    if (this.currEntry == null) {
                        Exceptions.noElementToRemove();
                    }
                    ValueCollection.access$600(this.this$1).remove(this.currEntry.getKey());
                    this.currEntry = null;
                }
            };
        }

        public int size() {
            return CharKeyChainedHashMap.this.size;
        }

        static /* synthetic */ CharKeyChainedHashMap access$600(ValueCollection x0) {
            return x0.CharKeyChainedHashMap.this;
        }
    }

    private class KeySet
    extends AbstractCharSet {
        private KeySet() {
        }

        public void clear() {
            CharKeyChainedHashMap.this.clear();
        }

        public boolean contains(char v) {
            return CharKeyChainedHashMap.this.getEntry(v) != null;
        }

        public CharIterator iterator() {
            return new CharIterator(this){
                Entry currEntry;
                int nextList;
                Entry nextEntry;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.currEntry = null;
                    this.nextList = this.nextList(0);
                    this.nextEntry = this.nextList == -1 ? null : CharKeyChainedHashMap.access$200(KeySet.access$400(this.this$1))[this.nextList];
                }

                int nextList(int index) {
                    while (index < CharKeyChainedHashMap.access$200(KeySet.access$400(this.this$1)).length && CharKeyChainedHashMap.access$200(KeySet.access$400(this.this$1))[index] == null) {
                        ++index;
                    }
                    return index < CharKeyChainedHashMap.access$200(KeySet.access$400(this.this$1)).length ? index : -1;
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public char next() {
                    if (this.nextEntry == null) {
                        Exceptions.endOfIterator();
                    }
                    this.currEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    if (this.nextEntry == null) {
                        this.nextList = this.nextList(this.nextList + 1);
                        if (this.nextList != -1) {
                            this.nextEntry = CharKeyChainedHashMap.access$200(KeySet.access$400(this.this$1))[this.nextList];
                        }
                    }
                    return this.currEntry.key;
                }

                public void remove() {
                    if (this.currEntry == null) {
                        Exceptions.noElementToRemove();
                    }
                    KeySet.access$400(this.this$1).remove(this.currEntry.getKey());
                    this.currEntry = null;
                }
            };
        }

        public boolean remove(char v) {
            boolean result = CharKeyChainedHashMap.this.containsKey(v);
            if (result) {
                CharKeyChainedHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return CharKeyChainedHashMap.this.size;
        }

        static /* synthetic */ CharKeyChainedHashMap access$400(KeySet x0) {
            return x0.CharKeyChainedHashMap.this;
        }
    }

    private static class Entry {
        char key;
        Object value;
        Entry next;

        Entry(char key, Object value) {
            this.key = key;
            this.value = value;
        }

        public char getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            Object eval = e.getValue();
            if (eval == null) {
                return e.getKey() == this.key && this.value == null;
            }
            return e.getKey() == this.key && e.getValue().equals(this.value);
        }
    }
}

