/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.AbstractDoubleCollection;
import bak.pcj.Adapter;
import bak.pcj.DoubleIterator;
import bak.pcj.adapter.IteratorToDoubleIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.Collection;

public class CollectionToDoubleCollectionAdapter
extends AbstractDoubleCollection {
    protected Collection collection;

    public CollectionToDoubleCollectionAdapter(Collection collection) {
        this(collection, false);
    }

    public CollectionToDoubleCollectionAdapter(Collection collection, boolean validate) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(double v) {
        return this.collection.add(new Double(v));
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(double v) {
        return this.collection.contains(new Double(v));
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public DoubleIterator iterator() {
        return new IteratorToDoubleIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(double v) {
        return this.collection.remove(new Double(v));
    }

    public int size() {
        return this.collection.size();
    }

    public boolean validate() {
        return Adapter.isDoubleAdaptable(this.collection);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("collection");
        }
    }
}

