/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DatatypeMessageFormatter {
    private static final String BASE_NAME = "org.apache.jena.ext.xerces.impl.msg.DatatypeMessages";

    public static String formatMessage(Locale locale, String key, Object[] arguments) throws MissingResourceException {
        Object msg;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(BASE_NAME, locale);
        try {
            msg = resourceBundle.getString(key);
            if (arguments != null) {
                try {
                    msg = MessageFormat.format((String)msg, arguments);
                }
                catch (Exception e) {
                    msg = resourceBundle.getString("FormatFailed");
                    msg = (String)msg + " " + resourceBundle.getString(key);
                }
            }
        }
        catch (MissingResourceException e) {
            String msg2 = resourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(key, msg2, key);
        }
        if (msg == null) {
            msg = key;
            if (arguments.length > 0) {
                StringBuffer str = new StringBuffer((String)msg);
                str.append('?');
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        str.append('&');
                    }
                    str.append(String.valueOf(arguments[i]));
                }
            }
        }
        return msg;
    }
}

