/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.CompletionWeight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.fst.Util;

public class ContextQuery
extends CompletionQuery
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(ContextQuery.class);
    private IntsRefBuilder scratch = new IntsRefBuilder();
    private Map<IntsRef, ContextMetaData> contexts;
    private boolean matchAllContexts = false;
    protected CompletionQuery innerQuery;
    private long ramBytesUsed;

    public ContextQuery(CompletionQuery query) {
        super(query.getTerm(), query.getFilter());
        if (query instanceof ContextQuery) {
            throw new IllegalArgumentException("'query' parameter must not be of type " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        this.innerQuery = query;
        this.contexts = new HashMap<IntsRef, ContextMetaData>();
        this.updateRamBytesUsed();
    }

    private void updateRamBytesUsed() {
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.contexts) + RamUsageEstimator.sizeOfObject((Object)((Object)this.innerQuery), (long)1024L);
    }

    public void addContext(CharSequence context) {
        this.addContext(context, 1.0f, true);
    }

    public void addContext(CharSequence context, float boost) {
        this.addContext(context, boost, true);
    }

    public void addContext(CharSequence context, float boost, boolean exact) {
        if (boost < 0.0f) {
            throw new IllegalArgumentException("'boost' must be >= 0");
        }
        for (int i = 0; i < context.length(); ++i) {
            if ('\u001d' != context.charAt(i)) continue;
            throw new IllegalArgumentException("Illegal value [" + context + "] UTF-16 codepoint [0x" + Integer.toHexString(context.charAt(i)) + "] at position " + i + " is a reserved character");
        }
        this.contexts.put(IntsRef.deepCopyOf((IntsRef)Util.toIntsRef((BytesRef)new BytesRef(context), (IntsRefBuilder)this.scratch)), new ContextMetaData(boost, exact));
        this.updateRamBytesUsed();
    }

    public void addAllContexts() {
        this.matchAllContexts = true;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        BytesRefBuilder scratch = new BytesRefBuilder();
        for (Map.Entry<IntsRef, ContextMetaData> entry : this.contexts.entrySet()) {
            if (buffer.length() != 0) {
                buffer.append(",");
            } else {
                buffer.append("contexts");
                buffer.append(":[");
            }
            buffer.append(Util.toBytesRef((IntsRef)entry.getKey(), (BytesRefBuilder)scratch).utf8ToString());
            ContextMetaData metaData = entry.getValue();
            if (!metaData.exact) {
                buffer.append("*");
            }
            if (metaData.boost == 0.0f) continue;
            buffer.append("^");
            buffer.append(Float.toString(metaData.boost));
        }
        if (buffer.length() != 0) {
            buffer.append("]");
            buffer.append(",");
        }
        return buffer.toString() + this.innerQuery.toString(field);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        CompletionWeight innerWeight = (CompletionWeight)this.innerQuery.createWeight(searcher, scoreMode, boost);
        Automaton innerAutomaton = innerWeight.getAutomaton();
        if (Operations.isEmpty((Automaton)innerAutomaton)) {
            return new CompletionWeight(this, Automata.makeEmpty());
        }
        Automaton optionalSepLabel = Operations.optional((Automaton)Automata.makeChar((int)31));
        Automaton prefixAutomaton = Operations.concatenate((Automaton)optionalSepLabel, (Automaton)innerAutomaton);
        Automaton contextsAutomaton = Operations.concatenate((Automaton)ContextQuery.toContextAutomaton(this.contexts, this.matchAllContexts), (Automaton)prefixAutomaton);
        contextsAutomaton = Operations.determinize((Automaton)contextsAutomaton, (int)10000);
        HashMap contextMap = CollectionUtil.newHashMap((int)this.contexts.size());
        TreeSet<Integer> contextLengths = new TreeSet<Integer>();
        for (Map.Entry<IntsRef, ContextMetaData> entry : this.contexts.entrySet()) {
            ContextMetaData contextMetaData = entry.getValue();
            contextMap.put(entry.getKey(), Float.valueOf(contextMetaData.boost));
            contextLengths.add(entry.getKey().length);
        }
        int[] contextLengthArray = new int[contextLengths.size()];
        Iterator iterator = contextLengths.descendingIterator();
        int i = 0;
        while (iterator.hasNext()) {
            contextLengthArray[i] = (Integer)iterator.next();
            ++i;
        }
        return new ContextCompletionWeight(this, contextsAutomaton, innerWeight, contextMap, contextLengthArray);
    }

    private static Automaton toContextAutomaton(Map<IntsRef, ContextMetaData> contexts, boolean matchAllContexts) {
        Automaton matchAllAutomaton = Operations.repeat((Automaton)Automata.makeAnyString());
        Automaton sep = Automata.makeChar((int)29);
        if (matchAllContexts || contexts.size() == 0) {
            return Operations.concatenate((Automaton)matchAllAutomaton, (Automaton)sep);
        }
        Automaton contextsAutomaton = null;
        for (Map.Entry<IntsRef, ContextMetaData> entry : contexts.entrySet()) {
            ContextMetaData contextMetaData = entry.getValue();
            IntsRef ref = entry.getKey();
            Automaton contextAutomaton = Automata.makeString((int[])ref.ints, (int)ref.offset, (int)ref.length);
            if (!contextMetaData.exact) {
                contextAutomaton = Operations.concatenate((Automaton)contextAutomaton, (Automaton)matchAllAutomaton);
            }
            contextAutomaton = Operations.concatenate((Automaton)contextAutomaton, (Automaton)sep);
            if (contextsAutomaton == null) {
                contextsAutomaton = contextAutomaton;
                continue;
            }
            contextsAutomaton = Operations.union((Automaton)contextsAutomaton, (Automaton)contextAutomaton);
        }
        return contextsAutomaton;
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    private static class ContextCompletionWeight
    extends CompletionWeight {
        private final Map<IntsRef, Float> contextMap;
        private final int[] contextLengths;
        private final CompletionWeight innerWeight;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private float currentBoost;
        private CharSequence currentContext;

        public ContextCompletionWeight(CompletionQuery query, Automaton automaton, CompletionWeight innerWeight, Map<IntsRef, Float> contextMap, int[] contextLengths) throws IOException {
            super(query, automaton);
            this.contextMap = contextMap;
            this.contextLengths = contextLengths;
            this.innerWeight = innerWeight;
        }

        @Override
        protected void setNextMatch(IntsRef pathPrefix) {
            IntsRef ref = pathPrefix.clone();
            for (int contextLength : this.contextLengths) {
                if (contextLength > pathPrefix.length) continue;
                ref.length = contextLength;
                if (!this.contextMap.containsKey(ref)) continue;
                this.currentBoost = this.contextMap.get(ref).floatValue();
                ref.length = pathPrefix.length;
                this.setInnerWeight(ref, contextLength);
                return;
            }
            ref.length = pathPrefix.length;
            this.currentBoost = 0.0f;
            this.setInnerWeight(ref, 0);
        }

        private void setInnerWeight(IntsRef ref, int offset) {
            IntsRefBuilder refBuilder = new IntsRefBuilder();
            for (int i = offset; i < ref.length; ++i) {
                if (ref.ints[ref.offset + i] != 29) continue;
                if (i > 0) {
                    refBuilder.copyInts(ref.ints, ref.offset, i);
                    this.currentContext = Util.toBytesRef((IntsRef)refBuilder.get(), (BytesRefBuilder)this.scratch).utf8ToString();
                } else {
                    this.currentContext = null;
                }
                ref.offset = ++i;
                assert (ref.offset < ref.length) : "input should not end with the context separator";
                if (ref.ints[i] == 31) {
                    ++ref.offset;
                    assert (ref.offset < ref.length) : "input should not end with a context separator followed by SEP_LABEL";
                }
                ref.length -= ref.offset;
                refBuilder.copyInts(ref.ints, ref.offset, ref.length);
                this.innerWeight.setNextMatch(refBuilder.get());
                return;
            }
        }

        @Override
        protected CharSequence context() {
            return this.currentContext;
        }

        @Override
        protected float boost() {
            return this.currentBoost + this.innerWeight.boost();
        }
    }

    private static class ContextMetaData {
        private final float boost;
        private final boolean exact;

        private ContextMetaData(float boost, boolean exact) {
            this.boost = boost;
            this.exact = exact;
        }
    }
}

