/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.interpolators;

import it.geosolutions.jaiext.interpolators.InterpolationNoData;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.iterator.RandomIter;

public class InterpolationNearest
extends Interpolation
implements InterpolationNoData {
    private static final long serialVersionUID = -6994369085300227735L;
    private boolean useROIAccessor;
    private Range noDataRange;
    private double destinationNoData;
    private Rectangle roiBounds;
    private int dataType;
    private int black;
    private boolean isNotPointRange;

    public int interpolateH(int[] samples, int arg1) {
        return samples[0];
    }

    public float interpolateH(float[] samples, float arg1) {
        return samples[0];
    }

    public double interpolateH(double[] samples, float arg1) {
        return samples[0];
    }

    public InterpolationNearest(Range noDataRange, boolean useROIAccessor, double destinationNoData, int dataType) {
        super(1, 1, 0, 0, 0, 0, 0, 0);
        if (noDataRange != null) {
            this.noDataRange = noDataRange;
            this.isNotPointRange = !noDataRange.isPoint();
        }
        this.useROIAccessor = useROIAccessor;
        this.destinationNoData = destinationNoData;
        this.black = (int)destinationNoData & 1;
        this.dataType = dataType;
    }

    public void setROIBounds(Rectangle roiBounds) {
        this.roiBounds = roiBounds;
    }

    @Override
    public double getDestinationNoData() {
        return this.destinationNoData;
    }

    @Override
    public void setDestinationNoData(double destinationNoData) {
        this.destinationNoData = destinationNoData;
    }

    @Override
    public boolean getUseROIAccessor() {
        return this.useROIAccessor;
    }

    @Override
    public void setUseROIAccessor(boolean useROIAccessor) {
        this.useROIAccessor = useROIAccessor;
    }

    @Override
    public Range getNoDataRange() {
        return this.noDataRange;
    }

    @Override
    public void setNoDataRange(Range noDataRange) {
        if (noDataRange != null) {
            this.noDataRange = noDataRange;
            this.isNotPointRange = !noDataRange.isPoint();
        }
    }

    public int getDataType() {
        return this.dataType;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Number interpolate(RasterAccessor src, int bandIndex, int dnumband, int posx, int posy, Integer yROIValue, RasterAccessor roiAccessor, RandomIter roiIter, boolean setNoData) {
        void var10_16;
        Object var10_10 = null;
        switch (this.dataType) {
            case 0: {
                byte srcDataByte = src.getByteDataArray(bandIndex)[posx + posy];
                if (this.noDataRange != null && this.noDataRange.contains(srcDataByte) || setNoData) {
                    return this.destinationNoData;
                }
                Byte by = srcDataByte;
                break;
            }
            case 1: 
            case 2: {
                short srcDataShort = src.getShortDataArray(bandIndex)[posx + posy];
                if (this.noDataRange != null && this.noDataRange.contains(srcDataShort) || setNoData) {
                    return this.destinationNoData;
                }
                Short s = srcDataShort;
                break;
            }
            case 3: {
                int srcDataInt = src.getIntDataArray(bandIndex)[posx + posy];
                if (this.noDataRange != null && this.noDataRange.contains(srcDataInt) || setNoData) {
                    return this.destinationNoData;
                }
                Integer n = srcDataInt;
                break;
            }
            case 4: {
                float srcDataFloat = src.getFloatDataArray(bandIndex)[posx + posy];
                if (this.noDataRange != null && this.noDataRange.contains(srcDataFloat) || this.isNotPointRange && Float.isNaN(srcDataFloat) || setNoData) {
                    return this.destinationNoData;
                }
                Float f = Float.valueOf(srcDataFloat);
                break;
            }
            case 5: {
                double srcDataDouble = src.getDoubleDataArray(bandIndex)[posx + posy];
                if (this.noDataRange != null && this.noDataRange.contains(srcDataDouble) || this.isNotPointRange && Double.isNaN(srcDataDouble) || setNoData) {
                    return this.destinationNoData;
                }
                Double d = srcDataDouble;
                break;
            }
        }
        if (this.useROIAccessor) {
            byte[] roiDataArray;
            if (roiAccessor == null || yROIValue == null) {
                throw new IllegalArgumentException("ROI Accessor or ROI y value not found");
            }
            int roiIndex = posx / dnumband + yROIValue;
            if (roiIndex >= (roiDataArray = roiAccessor.getByteDataArray(0)).length) return this.destinationNoData;
            switch (this.dataType) {
                case 0: {
                    byte valueROIByte = (byte)(roiDataArray[roiIndex] & 0xFF);
                    if (valueROIByte == 0) return this.destinationNoData;
                    return var10_16;
                }
                case 1: {
                    short valueROIUShort = (short)(roiDataArray[roiIndex] & 0xFFFF);
                    if (valueROIUShort == 0) return this.destinationNoData;
                    return var10_16;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    double valueROI = roiDataArray[roiIndex];
                    if (valueROI == 0.0) return this.destinationNoData;
                    return var10_16;
                }
            }
            return var10_16;
        } else {
            boolean insideROI;
            int y0;
            if (this.roiBounds == null) return var10_16;
            int x0 = src.getX() + posx / src.getPixelStride();
            if (!this.roiBounds.contains(x0, y0 = src.getY() + (posy - src.getBandOffset(bandIndex)) / src.getScanlineStride())) {
                return this.destinationNoData;
            }
            int wx = 0;
            switch (this.dataType) {
                case 0: {
                    wx = roiIter.getSample(x0, y0, 0) & 0xFF;
                    break;
                }
                case 1: {
                    wx = roiIter.getSample(x0, y0, 0) & 0xFFFF;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    wx = roiIter.getSample(x0, y0, 0);
                    break;
                }
            }
            boolean bl = insideROI = wx == 1;
            if (!insideROI) return this.destinationNoData;
            return var10_16;
        }
    }

    public int interpolateBinary(int xNextBitNo, Number[] sourceData, int sourceYOffset, int sourceScanlineStride, int[] coordinates, int[] roiDataArray, int roiYOffset, int roiScanlineStride, RandomIter roiIter) {
        int s = 0;
        int sshift = 0;
        int sbitnum = xNextBitNo - 1;
        int w00index = 0;
        int w00 = 1;
        if (coordinates != null && this.roiBounds != null && !this.useROIAccessor) {
            int x0 = coordinates[0];
            int y0 = coordinates[1];
            if (this.roiBounds.contains(x0, y0)) {
                w00 = roiIter.getSample(x0, y0, 0) & 1;
            } else {
                return this.black;
            }
        }
        switch (this.dataType) {
            case 0: {
                sshift = 7 - (sbitnum & 7);
                int sbytenum = sbitnum >> 3;
                s = sourceData[sourceYOffset + sbytenum].byteValue() >> sshift & 1;
                if (!this.useROIAccessor) break;
                w00index = roiYOffset + sbytenum;
                int roiDataLength = roiDataArray.length;
                w00 *= w00index < roiDataLength ? roiDataArray[w00index] >> sshift & 1 : 0;
                break;
            }
            case 1: 
            case 2: {
                int sshortnum = sbitnum >> 4;
                sshift = 15 - (sbitnum & 0xF);
                s = sourceData[sourceYOffset + sshortnum].shortValue() >> sshift & 1;
                if (!this.useROIAccessor) break;
                w00index = roiYOffset + sshortnum;
                int roiDataLength = roiDataArray.length;
                w00 *= w00index < roiDataLength ? roiDataArray[w00index] >> sshift & 1 : 0;
                break;
            }
            case 3: {
                int sintnum = sbitnum >> 5;
                sshift = 31 - (sbitnum & 0x1F);
                s = sourceData[sourceYOffset + sintnum].intValue() >> sshift & 1;
                if (!this.useROIAccessor) break;
                w00index = roiYOffset + sintnum;
                int roiDataLength = roiDataArray.length;
                w00 *= w00index < roiDataLength ? roiDataArray[w00index] >> sshift & 1 : 0;
                break;
            }
        }
        if (w00 == 0) {
            return this.black;
        }
        return s;
    }
}

