/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.data.PrjFileReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.files.FileReader;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.GeometryFactory;

class ShapefileSetManager
implements FileReader {
    private static final Logger LOGGER = Logging.getLogger(ShapefileSetManager.class);
    ShpFiles shpFiles;
    ShapefileDataStore store;

    public ShapefileSetManager(ShpFiles shpFiles, ShapefileDataStore store) {
        this.shpFiles = shpFiles;
        this.store = store;
    }

    protected ShapefileReader openShapeReader(GeometryFactory gf, boolean onlyRandomAccess) throws IOException {
        try {
            return new ShapefileReader(this.shpFiles, true, this.store.isMemoryMapped(), gf, onlyRandomAccess);
        }
        catch (ShapefileException se) {
            throw new DataSourceException("Error creating ShapefileReader", se);
        }
    }

    protected DbaseFileReader openDbfReader(boolean indexed) throws IOException {
        Charset charset;
        block29: {
            if (this.shpFiles.get(ShpFileType.DBF) == null) {
                return null;
            }
            if (this.shpFiles.isLocal() && !this.shpFiles.exists(ShpFileType.DBF)) {
                return null;
            }
            if (this.shpFiles.isLocal() && this.shpFiles.exists(ShpFileType.DBF)) {
                File file = URLs.urlToFile((URL)new URL(this.shpFiles.get(ShpFileType.DBF)));
                DbaseFileHeader header = new DbaseFileHeader();
                InputStream in = this.shpFiles.isGz() ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
                try (ReadableByteChannel channel = Channels.newChannel(in);){
                    header.readHeader(channel);
                }
                catch (IOException e) {
                    return null;
                }
                if (header.getHeaderLength() <= 0 || header.getNumFields() == 0) {
                    return null;
                }
            }
            charset = this.store.getCharset();
            if (this.store.isTryCPGFile() && this.shpFiles.get(ShpFileType.CPG) != null && (!this.shpFiles.isLocal() || this.shpFiles.isLocal() && this.shpFiles.exists(ShpFileType.CPG))) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(this.shpFiles.getInputStream(ShpFileType.CPG, this), StandardCharsets.ISO_8859_1));){
                    String charsetName = br.readLine();
                    if (charsetName != null) {
                        try {
                            charset = Charset.forName(charsetName.trim());
                            this.store.setCharset(charset);
                        }
                        catch (Exception e) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("Can't figure out charset from CPG file. Will use provided by the store.");
                            }
                        }
                    }
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.FINER)) break block29;
                    LOGGER.log(Level.FINER, "Ignoring invalid cpg file and moving on: " + e.getMessage());
                }
            }
        }
        try {
            if (indexed) {
                return new IndexedDbaseFileReader(this.shpFiles, this.store.isMemoryMapped(), charset, this.store.getTimeZone());
            }
            return new DbaseFileReader(this.shpFiles, this.store.isMemoryMapped(), charset, this.store.getTimeZone());
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Ignoring invalid dbf file and moving on: " + e.getMessage());
            }
            return null;
        }
    }

    protected PrjFileReader openPrjReader() throws IOException, FactoryException {
        if (this.shpFiles.get(ShpFileType.PRJ) == null) {
            return null;
        }
        if (this.shpFiles.isLocal() && !this.shpFiles.exists(ShpFileType.PRJ)) {
            return null;
        }
        try {
            return new PrjFileReader(this.shpFiles.getReadChannel(ShpFileType.PRJ, this));
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Ignoring invalid prj file and moving on: " + e.getMessage());
            }
            return null;
        }
    }

    protected IndexFile openIndexFile() throws IOException {
        if (this.shpFiles.get(ShpFileType.SHX) == null) {
            return null;
        }
        if (this.shpFiles.isLocal() && !this.shpFiles.exists(ShpFileType.SHX)) {
            return null;
        }
        try {
            return new IndexFile(this.shpFiles, this.store.isMemoryMapped());
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Ignoring invalid shx file and moving on: " + e.getMessage());
            }
            return null;
        }
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }
}

