/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicData;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.InvalidParameterNameException;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;

public class AzimuthalEquidistant {
    public static double EPS10 = 1.0E-10;
    public static double TOL = 1.0E-14;
    public static double HALF_PI = 1.5707963267948966;

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Azimuthal_Equidistant"), new NamedIdentifier(Citations.GEOTIFF, "CT_AzimuthalEquidistant"), new NamedIdentifier(Citations.GEOTOOLS, "Azimuthal Equidistant")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LONGITUDE_OF_CENTRE, LATITUDE_OF_CENTRE, FALSE_EASTING, FALSE_NORTHING, SCALE_FACTOR});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws InvalidParameterNameException, ParameterNotFoundException, InvalidParameterValueException, FactoryException {
            if (Provider.isSpherical(parameters)) {
                return new Spherical(parameters);
            }
            return new Ellipsoidal(parameters);
        }
    }

    public static class Ellipsoidal
    extends Abstract {
        protected transient Geodesic geodesic;
        protected final double Mp;

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.mode == Mode.OBLIQUE) {
                this.geodesic = this.buildGeodesic();
            }
        }

        private Geodesic buildGeodesic() {
            return new Geodesic(this.semiMajor, (this.semiMajor - this.semiMinor) / this.semiMajor);
        }

        protected Ellipsoidal(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
            switch (this.mode) {
                case NORTH_POLAR: {
                    this.Mp = this.mlfn(HALF_PI, 1.0, 0.0);
                    this.geodesic = null;
                    break;
                }
                case SOUTH_POLAR: {
                    this.Mp = this.mlfn(-HALF_PI, -1.0, 0.0);
                    this.geodesic = null;
                    break;
                }
                case EQUATORIAL: 
                case OBLIQUE: {
                    this.Mp = Double.NaN;
                    this.geodesic = this.buildGeodesic();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected mode " + this.mode + " for ellipsoidal AzimuthalEquidistant projection");
                }
            }
        }

        @Override
        protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
            double x = 0.0;
            double y = 0.0;
            double coslam = Math.cos(lambda);
            double cosphi = Math.cos(phi);
            double sinphi = Math.sin(phi);
            switch (this.mode) {
                case NORTH_POLAR: {
                    coslam = -coslam;
                }
                case SOUTH_POLAR: {
                    double rho = Math.abs(this.Mp - this.mlfn(phi, sinphi, cosphi));
                    x = rho * Math.sin(lambda);
                    y = rho * coslam;
                    break;
                }
                case EQUATORIAL: 
                case OBLIQUE: {
                    if (Math.abs(lambda) < EPS10 && Math.abs(phi - this.latitudeOfOrigin) < EPS10) {
                        x = 0.0;
                        y = 0.0;
                        break;
                    }
                    GeodesicData g = this.geodesic.Inverse(Math.toDegrees(this.latitudeOfOrigin), Math.toDegrees(this.centralMeridian), Math.toDegrees(phi), Math.toDegrees(lambda + this.centralMeridian));
                    double azi1 = Math.toRadians(g.azi1);
                    x = g.s12 * Math.sin(azi1) / this.semiMajor;
                    y = g.s12 * Math.cos(azi1) / this.semiMajor;
                }
            }
            if (ptDst == null) {
                return new Point2D.Double(x, y);
            }
            ptDst.setLocation(x, y);
            return ptDst;
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double lambda = 0.0;
            double phi = 0.0;
            double c = Math.hypot(x, y);
            if (c < EPS10) {
                phi = this.latitudeOfOrigin;
                lambda = 0.0;
            } else if (this.mode == Mode.OBLIQUE || this.mode == Mode.EQUATORIAL) {
                double x2 = x * this.semiMajor;
                double y2 = y * this.semiMajor;
                double azi1 = Math.atan2(x2, y2);
                double s12 = Math.sqrt(x2 * x2 + y2 * y2);
                GeodesicData g = this.geodesic.Direct(Math.toDegrees(this.latitudeOfOrigin), Math.toDegrees(this.centralMeridian), Math.toDegrees(azi1), s12);
                phi = Math.toRadians(g.lat2);
                lambda = Math.toRadians(g.lon2);
                lambda -= this.centralMeridian;
            } else {
                phi = this.inv_mlfn(this.mode == Mode.NORTH_POLAR ? this.Mp - c : this.Mp + c);
                lambda = Math.atan2(x, this.mode == Mode.NORTH_POLAR ? -y : y);
            }
            if (ptDst == null) {
                return new Point2D.Double(lambda, phi);
            }
            ptDst.setLocation(lambda, phi);
            return ptDst;
        }
    }

    public static class Spherical
    extends Abstract {
        protected Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
            this.ensureSpherical();
        }

        @Override
        protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
            double x = 0.0;
            double y = 0.0;
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double coslam = Math.cos(lambda);
            switch (this.mode) {
                case EQUATORIAL: 
                case OBLIQUE: {
                    y = this.mode == Mode.EQUATORIAL ? cosphi * coslam : this.sinph0 * sinphi + this.cosph0 * cosphi * coslam;
                    if (Math.abs(Math.abs(y) - 1.0) < TOL) {
                        if (y < 0.0) {
                            throw new ProjectionException("Tolerance error.");
                        }
                        x = 0.0;
                        y = 0.0;
                        break;
                    }
                    y = Math.acos(y);
                    y /= Math.sin(y);
                    x = y * cosphi * Math.sin(lambda);
                    y *= this.mode == Mode.EQUATORIAL ? sinphi : this.cosph0 * sinphi - this.sinph0 * cosphi * coslam;
                    break;
                }
                case NORTH_POLAR: {
                    phi = -phi;
                    coslam = -coslam;
                }
                case SOUTH_POLAR: {
                    if (Math.abs(phi - HALF_PI) < EPS10) {
                        throw new ProjectionException("Tolerance error.");
                    }
                    y = HALF_PI + phi;
                    x = y * Math.sin(lambda);
                    y *= coslam;
                }
            }
            if (ptDst == null) {
                return new Point2D.Double(x, y);
            }
            ptDst.setLocation(x, y);
            return ptDst;
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double lambda = 0.0;
            double phi = 0.0;
            double c_rh = Math.hypot(x, y);
            if (c_rh > Math.PI) {
                if (c_rh - EPS10 > Math.PI) {
                    throw new ProjectionException("Tolerance error.");
                }
                c_rh = Math.PI;
            } else if (c_rh < EPS10) {
                phi = this.latitudeOfOrigin;
                lambda = 0.0;
            } else if (this.mode == Mode.OBLIQUE || this.mode == Mode.EQUATORIAL) {
                double sinc = Math.sin(c_rh);
                double cosc = Math.cos(c_rh);
                if (this.mode == Mode.EQUATORIAL) {
                    phi = this.aasin(y * sinc / c_rh);
                    x *= sinc;
                    y = cosc * c_rh;
                } else {
                    phi = this.aasin(cosc * this.sinph0 + y * sinc * this.cosph0 / c_rh);
                    y = (cosc - this.sinph0 * Math.sin(phi)) * c_rh;
                    x *= sinc * this.cosph0;
                }
                lambda = y == 0.0 ? 0.0 : Math.atan2(x, y);
            } else if (this.mode == Mode.NORTH_POLAR) {
                phi = HALF_PI - c_rh;
                lambda = Math.atan2(x, -y);
            } else {
                phi = c_rh - HALF_PI;
                lambda = Math.atan2(x, y);
            }
            if (ptDst == null) {
                return new Point2D.Double(lambda, phi);
            }
            ptDst.setLocation(lambda, phi);
            return ptDst;
        }
    }

    public static abstract class Abstract
    extends MapProjection {
        protected final Mode mode;
        protected final double sinph0;
        protected final double cosph0;

        protected Abstract(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
            List parameterDescriptors = this.getParameterDescriptors().descriptors();
            this.centralMeridian = this.doubleValue(parameterDescriptors, Provider.LONGITUDE_OF_CENTRE, parameters);
            this.latitudeOfOrigin = this.doubleValue(parameterDescriptors, Provider.LATITUDE_OF_CENTRE, parameters);
            Abstract.ensureLongitudeInRange(Provider.LONGITUDE_OF_CENTRE, this.centralMeridian, true);
            Abstract.ensureLatitudeInRange(Provider.LATITUDE_OF_CENTRE, this.latitudeOfOrigin, true);
            if (Math.abs(this.latitudeOfOrigin - HALF_PI) < EPS10) {
                this.mode = Mode.NORTH_POLAR;
                this.sinph0 = 1.0;
                this.cosph0 = 0.0;
            } else if (Math.abs(this.latitudeOfOrigin + HALF_PI) < EPS10) {
                this.mode = Mode.SOUTH_POLAR;
                this.sinph0 = -1.0;
                this.cosph0 = 0.0;
            } else if (Math.abs(this.latitudeOfOrigin) < EPS10) {
                this.mode = Mode.EQUATORIAL;
                this.sinph0 = 0.0;
                this.cosph0 = 1.0;
            } else {
                this.mode = Mode.OBLIQUE;
                this.sinph0 = Math.sin(this.latitudeOfOrigin);
                this.cosph0 = Math.cos(this.latitudeOfOrigin);
            }
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return Provider.PARAMETERS;
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            ParameterValueGroup values = super.getParameterValues();
            List descriptors = this.getParameterDescriptors().descriptors();
            this.set(descriptors, Provider.LONGITUDE_OF_CENTRE, values, this.centralMeridian);
            this.set(descriptors, Provider.LATITUDE_OF_CENTRE, values, this.latitudeOfOrigin);
            return values;
        }
    }

    public static enum Mode {
        NORTH_POLAR,
        SOUTH_POLAR,
        EQUATORIAL,
        OBLIQUE;

    }
}

