/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.encoding.Encoding;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.fonts.type1.PFBParser;
import org.apache.fop.fonts.type1.PostscriptParser;
import org.apache.fop.fonts.type1.Type1SubsetFile;
import org.apache.fop.render.pdf.pdfbox.FontContainer;
import org.apache.fop.render.pdf.pdfbox.MergeFonts;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class MergeType1Fonts
extends Type1SubsetFile
implements MergeFonts {
    private Map<Integer, String> nameMap = new HashMap<Integer, String>();
    private PostscriptParser.PSElement encoding;
    private List<String> subsetEncodingEntries = new ArrayList<String>();
    private PFBData pfbData = null;
    private byte[] decoded;
    private PostscriptParser.PSElement charStrings;
    private ByteArrayOutputStream subrsBeforeStream = new ByteArrayOutputStream();
    private ByteArrayOutputStream subrsEndStream = new ByteArrayOutputStream();
    private Map<Integer, byte[]> subByteMap = new HashMap<Integer, byte[]>();

    public MergeType1Fonts() {
        this.uniqueSubs = new LinkedHashMap();
        this.subsetCharStrings = new HashMap();
        this.charNames = new ArrayList();
        this.subsetSubroutines = false;
        this.subsetEncodingEntries.add("dup 0 /.notdef put");
    }

    @Override
    public void readFont(InputStream fontFile, String name, FontContainer font, Map<Integer, Integer> subsetGlyphs, boolean cid) throws IOException {
        PFBParser pfbParser = new PFBParser();
        this.pfbData = pfbParser.parsePFB(fontFile);
        PostscriptParser psParser = new PostscriptParser();
        ArrayList<Integer> glyphs = new ArrayList<Integer>();
        Type1Font t1f = ((PDType1Font)font.font).getType1Font();
        Encoding enc = t1f.getEncoding();
        for (int i = font.getFirstChar(); i <= font.getLastChar(); ++i) {
            if (enc.getName(i).equals(".notdef")) continue;
            this.nameMap.put(i, enc.getName(i));
            glyphs.add(i);
        }
        Collections.sort(glyphs);
        this.headerSection = psParser.parse(this.pfbData.getHeaderSegment());
        this.encoding = this.getElement("/Encoding", this.headerSection);
        if (this.encoding.getFoundUnexpected()) {
            throw new IOException("unable to interpret postscript on arrays");
        }
        List<String> encodingEntries = this.readEncoding(glyphs, this.encoding);
        for (String e : encodingEntries) {
            if (e == null || this.subsetEncodingEntries.contains(e)) continue;
            this.subsetEncodingEntries.add(e);
        }
        this.decoded = Type1SubsetFile.BinaryCoder.decodeBytes((byte[])this.pfbData.getEncryptedSegment(), (int)55665, (int)4);
        this.mainSection = psParser.parse(this.decoded);
        PostscriptParser.PSFixedArray subroutines = (PostscriptParser.PSFixedArray)this.getElement("/Subrs", this.mainSection);
        this.charStrings = this.getElement("/CharStrings", this.mainSection);
        if (subroutines != null) {
            this.subrsBeforeStream.reset();
            this.subrsBeforeStream.write(this.decoded, 0, subroutines.getStartPoint());
            this.subrsEndStream.reset();
            this.subrsEndStream.write(this.decoded, subroutines.getEndPoint(), this.charStrings.getStartPoint() - subroutines.getEndPoint());
        }
        List subArray = t1f.getSubrsArray();
        for (int i = 0; i < subArray.size(); ++i) {
            if (this.subByteMap.containsKey(i) && !Arrays.equals(this.subByteMap.get(i), (byte[])subArray.get(i))) {
                throw new IOException("Can't merge font subroutines " + font.font.getName());
            }
            this.subByteMap.put(i, (byte[])subArray.get(i));
        }
        Map cs = t1f.getCharStringsDict();
        int lenIV = 4;
        PostscriptParser.PSElement element = this.getElement("/lenIV", this.mainSection);
        if (element != null && element instanceof PostscriptParser.PSVariable) {
            PostscriptParser.PSVariable lenIVVar = (PostscriptParser.PSVariable)element;
            lenIV = Integer.parseInt(lenIVVar.getValue());
        }
        for (String e : cs.keySet()) {
            int[] be = (int[])this.charStrings.getBinaryEntries().get("/" + e);
            if (be == null) continue;
            byte[] charStringEntry = this.getBinaryEntry(be, this.decoded);
            if (lenIV != 4) {
                charStringEntry = Type1SubsetFile.BinaryCoder.decodeBytes((byte[])charStringEntry, (int)4330, (int)lenIV);
                charStringEntry = Type1SubsetFile.BinaryCoder.encodeBytes((byte[])charStringEntry, (int)4330, (int)4);
            }
            this.subsetCharStrings.put("/" + e, charStringEntry);
        }
    }

    @Override
    public byte[] getMergedFontSubset() throws IOException {
        ByteArrayOutputStream boasHeader = this.writeHeader(this.pfbData, this.encoding);
        ByteArrayOutputStream boasMain = this.writeMainSection(this.decoded, this.mainSection, this.charStrings);
        byte[] mainSectionBytes = Type1SubsetFile.BinaryCoder.encodeBytes((byte[])boasMain.toByteArray(), (int)55665, (int)4);
        boasMain.reset();
        boasMain.write(mainSectionBytes);
        ByteArrayOutputStream baosTrailer = new ByteArrayOutputStream();
        baosTrailer.write(this.pfbData.getTrailerSegment(), 0, this.pfbData.getTrailerSegment().length);
        return this.stitchFont(boasHeader, boasMain, baosTrailer);
    }

    protected List<String> searchEntries(HashMap<Integer, String> encodingEntries, int glyph) {
        ArrayList<String> matches = new ArrayList<String>();
        for (Map.Entry<Integer, String> entry : encodingEntries.entrySet()) {
            String tag = this.getEntryPart(entry.getValue(), 3);
            String name = "/" + this.nameMap.get(glyph);
            if (!name.equals(tag)) continue;
            matches.add(entry.getValue());
        }
        return matches;
    }

    protected List<String> readEncoding(List<Integer> glyphs, PostscriptParser.PSElement encoding) {
        ArrayList<String> subsetEncodingEntries = new ArrayList<String>();
        if (encoding instanceof PostscriptParser.PSFixedArray) {
            PostscriptParser.PSFixedArray encodingArray = (PostscriptParser.PSFixedArray)encoding;
            for (int glyph : glyphs) {
                if (glyph == 0) continue;
                List<String> matches = this.searchEntries(encodingArray.getEntries(), glyph);
                if (matches.isEmpty()) {
                    matches.clear();
                    matches.add((String)encodingArray.getEntries().get(glyph));
                }
                for (String match : matches) {
                    subsetEncodingEntries.add(match);
                }
            }
        } else if (encoding instanceof PostscriptParser.PSVariable) {
            if (((PostscriptParser.PSVariable)encoding).getValue().equals("StandardEncoding")) {
                this.standardEncoding = true;
                for (Map.Entry<Integer, String> v : this.nameMap.entrySet()) {
                    subsetEncodingEntries.add(String.format("dup %d /%s put", v.getKey(), v.getValue()));
                }
            } else {
                throw new RuntimeException("Only Custom or StandardEncoding is supported when creating a Type 1 subset.");
            }
        }
        return subsetEncodingEntries;
    }

    protected ByteArrayOutputStream writeHeader(PFBData pfbData, PostscriptParser.PSElement encoding) throws IOException {
        ByteArrayOutputStream boasHeader = new ByteArrayOutputStream();
        boasHeader.write(pfbData.getHeaderSegment(), 0, encoding.getStartPoint() - 1);
        if (!this.standardEncoding) {
            String encodingArray = this.eol + "/Encoding 256 array" + this.eol + "0 1 255 {1 index exch /.notdef put } for" + this.eol;
            byte[] encodingDefinition = encodingArray.getBytes("ASCII");
            boasHeader.write(encodingDefinition, 0, encodingDefinition.length);
            for (Map.Entry<Integer, String> entry : this.nameMap.entrySet()) {
                String arrayEntry = String.format("dup %d /%s put", entry.getKey(), entry.getValue());
                this.writeString(arrayEntry + this.eol, boasHeader);
            }
            this.writeString("readonly def" + this.eol, boasHeader);
        } else {
            String theEncoding = this.eol + "/Encoding StandardEncoding def" + this.eol;
            boasHeader.write(theEncoding.getBytes("ASCII"));
        }
        boasHeader.write(pfbData.getHeaderSegment(), encoding.getEndPoint(), pfbData.getHeaderSegment().length - encoding.getEndPoint());
        return boasHeader;
    }

    protected ByteArrayOutputStream writeMainSection(byte[] decoded, List<PostscriptParser.PSElement> mainSection, PostscriptParser.PSElement charStrings) throws IOException {
        ByteArrayOutputStream main = new ByteArrayOutputStream();
        String rd = this.findVariable(decoded, mainSection, new String[]{"string currentfile exch readstring pop"}, "RD");
        String nd = this.findVariable(decoded, mainSection, new String[]{"def", "noaccess def"}, "noaccess def");
        String np = this.findVariable(decoded, mainSection, new String[]{"put", "noaccess put"}, "noaccess put");
        main.write(this.subrsBeforeStream.toByteArray());
        this.writeString("/lenIV 4 def", main);
        this.writeString("/Subrs " + this.subByteMap.size() + " array" + this.eol, main);
        for (Map.Entry<Integer, byte[]> entry : this.subByteMap.entrySet()) {
            if (entry.getValue() == null) continue;
            byte[] encoded = Type1SubsetFile.BinaryCoder.encodeBytes((byte[])entry.getValue(), (int)4330, (int)4);
            this.writeString("dup " + entry.getKey() + " " + encoded.length + " " + rd + " ", main);
            main.write(encoded);
            this.writeString(" " + np + this.eol, main);
        }
        this.writeString(nd + this.eol, main);
        main.write(this.subrsEndStream.toByteArray());
        this.writeString(this.eol + String.format("/CharStrings %d dict dup begin", this.subsetCharStrings.size()), main);
        for (Map.Entry<Integer, Object> entry : this.subsetCharStrings.entrySet()) {
            this.writeString(this.eol + String.format("%s %d %s ", entry.getKey(), ((byte[])entry.getValue()).length, rd), main);
            main.write((byte[])entry.getValue());
            this.writeString(" " + nd, main);
        }
        this.writeString(this.eol + "end", main);
        main.write(decoded, charStrings.getEndPoint(), decoded.length - charStrings.getEndPoint());
        return main;
    }
}

