/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.stream.MatchpointSearchResults;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;

public class RollbackProhibitedException
extends RestartRequiredException {
    private final MatchpointSearchResults searchResults;
    private final String nodeName;
    private final int rollbackTxnLimit;
    private final VLSN matchpointVLSN;

    public RollbackProhibitedException(RepImpl repImpl, int rollbackTxnLimit, VLSN matchpointVLSN, MatchpointSearchResults searchResults) {
        super(repImpl, EnvironmentFailureReason.ROLLBACK_PROHIBITED);
        this.rollbackTxnLimit = rollbackTxnLimit;
        this.searchResults = searchResults;
        this.nodeName = repImpl.getName();
        this.matchpointVLSN = matchpointVLSN;
    }

    public String getMessage() {
        long matchpointLSN = this.searchResults.getMatchpointLSN();
        return "Node " + this.nodeName + " must rollback " + this.searchResults.getRollbackMsg() + " in order to rejoin the replication group, but the transaction " + "rollback limit of " + this.rollbackTxnLimit + " prohibits this. To " + "remove the problematic transactions, truncate the log to file " + DbLsn.getFileNumber(matchpointLSN) + " offset " + DbLsn.getFileOffset(matchpointLSN) + " vlsn " + this.matchpointVLSN + " using com.sleepycat.je.util.DbTruncateLog";
    }

    public RollbackProhibitedException(String message, RollbackProhibitedException cause) {
        super(message, cause);
        this.rollbackTxnLimit = cause.rollbackTxnLimit;
        this.searchResults = cause.searchResults;
        this.nodeName = cause.nodeName;
        this.matchpointVLSN = cause.matchpointVLSN;
    }

    public RollbackProhibitedException wrapSelf(String msg) {
        return new RollbackProhibitedException(msg, this);
    }

    public long getTruncationFileNumber() {
        return DbLsn.getFileNumber(this.searchResults.getMatchpointLSN());
    }

    public long getTruncationFileOffset() {
        return DbLsn.getFileOffset(this.searchResults.getMatchpointLSN());
    }

    public Long getEarliestTransactionCommitTime() {
        return this.searchResults.getEarliestPassedTxn().time.getTime();
    }

    public long getEarliestTransactionId() {
        return this.searchResults.getEarliestPassedTxn().id;
    }
}

