/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.IsoAlg;
import org.apache.jena.sparql.util.NodeUtils;

public class IsoMatcher {
    public static boolean isomorphic(Graph g1, Graph g2) {
        List<Tuple<Node>> x1 = IsoMatcher.tuplesTriples((Iterator<Triple>)g1.find());
        List<Tuple<Node>> x2 = IsoMatcher.tuplesTriples((Iterator<Triple>)g2.find());
        return IsoMatcher.isomorphic(x1, x2, NodeUtils.sameRdfTerm);
    }

    public static boolean isomorphic(DatasetGraph dsg1, DatasetGraph dsg2) {
        List<Tuple<Node>> x1 = IsoMatcher.tuplesQuads(dsg1.find());
        List<Tuple<Node>> x2 = IsoMatcher.tuplesQuads(dsg2.find());
        return IsoMatcher.isomorphic(x1, x2, NodeUtils.sameRdfTerm);
    }

    public static boolean isomorphic(Collection<Tuple<Node>> x1, Collection<Tuple<Node>> x2) {
        return IsoMatcher.isomorphic(x1, x2, NodeUtils.sameRdfTerm);
    }

    static List<Tuple<Node>> tuplesTriples(Iterator<Triple> iter) {
        return Iter.iter(iter).map(t -> TupleFactory.tuple((Object[])new Node[]{t.getSubject(), t.getPredicate(), t.getObject()})).toList();
    }

    public static List<Tuple<Node>> tuplesQuads(Iterator<Quad> iter) {
        return Iter.iter(iter).map(q -> TupleFactory.tuple((Object[])new Node[]{q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject()})).toList();
    }

    public static boolean isomorphic(Collection<Tuple<Node>> x1, Collection<Tuple<Node>> x2, EqualityTest nodeTest) {
        return IsoAlg.isIsomorphic(x1, x2, nodeTest);
    }
}

