/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc.impl;

import java.text.DecimalFormat;
import org.marc4j.marc.Leader;

public class LeaderImpl
implements Leader {
    private Long id;
    private int recordLength;
    private char recordStatus;
    private char typeOfRecord;
    private char[] implDefined1;
    private char charCodingScheme;
    private int indicatorCount;
    private int subfieldCodeLength;
    private int baseAddressOfData;
    private char[] implDefined2;
    private char[] entryMap;
    DecimalFormat df = new DecimalFormat("00000");
    private static DecimalFormat format5 = new DecimalFormat("00000");

    public LeaderImpl() {
    }

    public LeaderImpl(String ldr) {
        this.unmarshal(ldr);
    }

    public void setRecordLength(int recordLength) {
        this.recordLength = recordLength;
    }

    public void setRecordStatus(char recordStatus) {
        this.recordStatus = recordStatus;
    }

    public void setTypeOfRecord(char typeOfRecord) {
        this.typeOfRecord = typeOfRecord;
    }

    public void setImplDefined1(char[] implDefined1) {
        this.implDefined1 = implDefined1;
    }

    public void setCharCodingScheme(char charCodingScheme) {
        this.charCodingScheme = charCodingScheme;
    }

    public void setIndicatorCount(int indicatorCount) {
        this.indicatorCount = indicatorCount;
    }

    public void setSubfieldCodeLength(int subfieldCodeLength) {
        this.subfieldCodeLength = subfieldCodeLength;
    }

    public void setBaseAddressOfData(int baseAddressOfData) {
        this.baseAddressOfData = baseAddressOfData;
    }

    public void setImplDefined2(char[] implDefined2) {
        this.implDefined2 = implDefined2;
    }

    public void setEntryMap(char[] entryMap) {
        this.entryMap = entryMap;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public char getRecordStatus() {
        return this.recordStatus;
    }

    public char getTypeOfRecord() {
        return this.typeOfRecord;
    }

    public char[] getImplDefined1() {
        return this.implDefined1;
    }

    public char getCharCodingScheme() {
        return this.charCodingScheme;
    }

    public int getIndicatorCount() {
        return this.indicatorCount;
    }

    public int getSubfieldCodeLength() {
        return this.subfieldCodeLength;
    }

    public int getBaseAddressOfData() {
        return this.baseAddressOfData;
    }

    public char[] getImplDefined2() {
        return this.implDefined2;
    }

    public char[] getEntryMap() {
        return this.entryMap;
    }

    public void unmarshal(String ldr) {
        try {
            String s = ldr.substring(0, 5);
            if (this.isInteger(s)) {
                this.setRecordLength(Integer.parseInt(s));
            } else {
                this.setRecordLength(0);
            }
            this.setRecordStatus(ldr.charAt(5));
            this.setTypeOfRecord(ldr.charAt(6));
            this.setImplDefined1(ldr.substring(7, 9).toCharArray());
            this.setCharCodingScheme(ldr.charAt(9));
            s = String.valueOf(ldr.charAt(10));
            if (this.isInteger(s)) {
                this.setIndicatorCount(Integer.parseInt(s));
            } else {
                this.setIndicatorCount(2);
            }
            s = String.valueOf(ldr.charAt(10));
            if (this.isInteger(s)) {
                this.setSubfieldCodeLength(Integer.parseInt(s));
            } else {
                this.setSubfieldCodeLength(2);
            }
            s = ldr.substring(12, 17);
            if (this.isInteger(s)) {
                this.setBaseAddressOfData(Integer.parseInt(s));
            } else {
                this.setBaseAddressOfData(0);
            }
            this.setImplDefined2(ldr.substring(17, 20).toCharArray());
            this.setEntryMap(ldr.substring(20, 24).toCharArray());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Unable to parse leader", e);
        }
    }

    public String marshal() {
        return this.toString();
    }

    public String toString() {
        return format5.format(this.getRecordLength()) + this.getRecordStatus() + this.getTypeOfRecord() + this.getImplDefined1() + this.getCharCodingScheme() + this.getIndicatorCount() + this.getSubfieldCodeLength() + format5.format(this.getBaseAddressOfData()) + this.getImplDefined2() + this.getEntryMap();
    }

    private boolean isInteger(String value) {
        int len = value.length();
        if (len == 0) {
            return false;
        }
        int i = 0;
        do {
            switch (value.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (++i < len);
        return true;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }
}

