/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.sparql.syntax.syntaxtransform.ApplyElementTransformVisitor;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;

public class ElementTransformer {
    private static ElementTransformer singleton = new ElementTransformer();

    public static ElementTransformer get() {
        return singleton;
    }

    public static void set(ElementTransformer value) {
        singleton = value;
    }

    public static Element transform(Element element, ElementTransform transform) {
        return ElementTransformer.transform(element, transform, null, null, null);
    }

    public static Element transform(Element element, ElementTransform transform, ExprTransform exprTransform) {
        return ElementTransformer.get().transformation(element, transform, exprTransform, null, null);
    }

    public static Element transform(Element element, ElementTransform transform, ExprTransform exprTransform, ElementVisitor beforeVisitor, ElementVisitor afterVisitor) {
        return ElementTransformer.get().transformation(element, transform, exprTransform, beforeVisitor, afterVisitor);
    }

    protected Element transformation(Element element, ElementTransform transform, ExprTransform exprTransform, ElementVisitor beforeVisitor, ElementVisitor afterVisitor) {
        ApplyElementTransformVisitor v = new ApplyElementTransformVisitor(transform, exprTransform);
        return this.transformation(v, element, beforeVisitor, afterVisitor);
    }

    protected Element transformation(ApplyElementTransformVisitor transformApply, Element element, ElementVisitor beforeVisitor, ElementVisitor afterVisitor) {
        if (element == null) {
            Log.warn((Object)this, (String)"Attempt to transform a null element - ignored");
            return element;
        }
        return this.applyTransformation(transformApply, element, beforeVisitor, afterVisitor);
    }

    protected Element applyTransformation(ApplyElementTransformVisitor transformApply, Element element, ElementVisitor beforeVisitor, ElementVisitor afterVisitor) {
        ElementWalker.walk(element, transformApply, beforeVisitor, afterVisitor);
        Element r = transformApply.result();
        return r;
    }

    protected ElementTransformer() {
    }
}

