/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionEnv;

public class AggSum
extends AggregatorBase {
    private static final NodeValue noValuesToSum = NodeValue.nvZERO;

    public AggSum(Expr expr) {
        super("SUM", false, expr);
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        return new AggSum(exprs.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccSum(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToSum);
    }

    @Override
    public int hashCode() {
        return 0x17C ^ this.getExpr().hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggSum)) {
            return false;
        }
        AggSum agg = (AggSum)other;
        return this.getExpr().equals(agg.getExpr(), bySyntax);
    }

    private static class AccSum
    extends AccumulatorExpr {
        private NodeValue total = null;

        public AccSum(Expr expr) {
            super(expr, false);
        }

        @Override
        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (nv.isNumber()) {
                this.total = this.total == null ? nv : XSDFuncOp.numAdd(nv, this.total);
            } else {
                throw new ExprEvalException("Not a number: " + nv);
            }
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return this.total;
        }
    }
}

