/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sailimpl.nativerdf.Namespace;

public class NamespaceStore {
    private static final String FILE_NAME = "namespaces.dat";
    private static final int EXPORT_FLAG = 1;
    private File _file;
    private Namespace[] _namespaces;
    private Namespace[] _txnNamespaces;
    private Map _namespacesMap;
    private Map _txnNamespacesMap;
    private boolean _contentsChanged;

    public NamespaceStore(File dataDir) throws IOException {
        this._file = new File(dataDir, FILE_NAME);
        this._file.createNewFile();
        this._namespaces = new Namespace[16];
        this._namespacesMap = new HashMap(16);
        this._readNamespacesFromFile();
    }

    public int getID(String namespace) {
        return this.getID(namespace, false);
    }

    public int getID(String namespace, boolean dirtyReads) {
        Map nsMap = dirtyReads ? this._txnNamespacesMap : this._namespacesMap;
        Namespace ns = (Namespace)nsMap.get(namespace);
        if (ns != null) {
            return ns.getID();
        }
        return 0;
    }

    public Namespace getNamespace(int id) {
        return this.getNamespace(id, false);
    }

    public Namespace getNamespace(int id, boolean dirtyReads) {
        Namespace[] namespaces;
        Namespace[] namespaceArray = namespaces = dirtyReads ? this._txnNamespaces : this._namespaces;
        if (id >= 0 && id < namespaces.length) {
            return namespaces[id];
        }
        return null;
    }

    public String getNamespaceName(int id) {
        return this.getNamespaceName(id, false);
    }

    public String getNamespaceName(int id, boolean dirtyReads) {
        Namespace ns = this.getNamespace(id, dirtyReads);
        if (ns != null) {
            return ns.getName();
        }
        return null;
    }

    public NamespaceIterator getNamespaces() {
        return new NI(this._namespaces);
    }

    public void startTransaction() {
        this._txnNamespaces = new Namespace[this._namespaces.length];
        System.arraycopy(this._namespaces, 0, this._txnNamespaces, 0, this._namespaces.length);
        this._txnNamespacesMap = new HashMap(this._namespacesMap);
        this._contentsChanged = false;
    }

    public void commitTransaction() throws IOException {
        this._commitTransaction(true);
    }

    private void _commitTransaction(boolean flushToFile) throws IOException {
        if (this._contentsChanged) {
            this._namespaces = this._txnNamespaces;
            this._namespacesMap = this._txnNamespacesMap;
            if (flushToFile) {
                this._writeNamespacesToFile();
            }
            this._contentsChanged = false;
        }
        this._txnNamespaces = null;
        this._txnNamespacesMap = null;
    }

    public void rollbackTransaction() {
        this._txnNamespaces = null;
        this._txnNamespacesMap = null;
        this._contentsChanged = false;
    }

    public void close() {
        if (this._txnNamespaces != null) {
            this.rollbackTransaction();
        }
        this._namespaces = null;
        this._namespacesMap = null;
        this._file = null;
    }

    public void clear() {
        this._txnNamespaces = new Namespace[16];
        this._txnNamespacesMap = new HashMap(16);
        this._contentsChanged = true;
    }

    public int storeNamespace(String namespace) {
        int id;
        for (id = 1; id < this._txnNamespaces.length && this._txnNamespaces[id] != null; ++id) {
        }
        Namespace ns = new Namespace(id, "ns" + id, namespace);
        this._storeNamespace(ns);
        return id;
    }

    private void _storeNamespace(Namespace ns) {
        int id = ns.getID();
        if (id >= this._txnNamespaces.length) {
            int newSize = Math.max(2 * this._txnNamespaces.length, id + 1);
            Namespace[] newArray = new Namespace[newSize];
            System.arraycopy(this._txnNamespaces, 0, newArray, 0, this._txnNamespaces.length);
            this._txnNamespaces = newArray;
        }
        this._txnNamespaces[id] = ns;
        this._txnNamespacesMap.put(ns.getName(), ns);
        this._contentsChanged = true;
    }

    public void setNamespacePrefix(String prefix, String name) {
        Namespace ns = (Namespace)this._txnNamespacesMap.get(name);
        if (ns != null && this._getNamespaceForPrefix(prefix) == null) {
            ns.setPrefix(prefix);
            ns.setExported(true);
            this._contentsChanged = true;
        }
    }

    private Namespace _getNamespaceForPrefix(String prefix) {
        for (int i = 0; i < this._txnNamespaces.length; ++i) {
            Namespace ns = this._txnNamespaces[i];
            if (ns == null || !ns.getPrefix().equals(prefix)) continue;
            return ns;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeNamespacesToFile() throws IOException {
        File file = this._file;
        synchronized (file) {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(this._file));
            try {
                for (int i = 0; i < this._namespaces.length; ++i) {
                    Namespace ns = this._namespaces[i];
                    if (ns == null) continue;
                    int flag = 0;
                    if (ns.exported()) {
                        flag |= 1;
                    }
                    out.writeInt(ns.getID());
                    out.writeByte(flag);
                    out.writeUTF(ns.getPrefix());
                    out.writeUTF(ns.getName());
                }
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _readNamespacesFromFile() throws IOException {
        File file = this._file;
        synchronized (file) {
            this.startTransaction();
            DataInputStream in = new DataInputStream(new FileInputStream(this._file));
            try {
                try {
                    while (true) {
                        int id = in.readInt();
                        byte flag = in.readByte();
                        String prefix = in.readUTF();
                        String name = in.readUTF();
                        boolean export = (flag & 1) == 1;
                        Namespace ns = new Namespace(id, prefix, name, export);
                        this._storeNamespace(ns);
                    }
                }
                catch (EOFException e) {
                    in.close();
                }
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            this._commitTransaction(false);
        }
    }

    public static void main(String[] args) throws Exception {
        NamespaceStore nsStore = new NamespaceStore(new File(args[0]));
        Namespace[] namespaces = nsStore._namespaces;
        for (int i = 0; i < namespaces.length; ++i) {
            Namespace ns = namespaces[i];
            if (ns == null) continue;
            System.out.println("ID " + ns.getID() + ": prefix='" + ns.getPrefix() + "', name='" + ns.getName() + "'");
        }
    }

    private static class NI
    implements NamespaceIterator {
        private Namespace[] _namespaces;
        private int _nextNamespace;
        private Namespace _currentNamespace;

        public NI(Namespace[] namespaces) {
            this._namespaces = namespaces;
            this._nextNamespace = 0;
            this._findNextNamespace();
        }

        private void _findNextNamespace() {
            ++this._nextNamespace;
            while (this._nextNamespace < this._namespaces.length && this._namespaces[this._nextNamespace] == null) {
                ++this._nextNamespace;
            }
        }

        public boolean hasNext() {
            return this._nextNamespace < this._namespaces.length;
        }

        public void next() {
            this._currentNamespace = this._namespaces[this._nextNamespace];
            this._findNextNamespace();
        }

        public String getName() {
            return this._currentNamespace.getName();
        }

        public String getPrefix() {
            return this._currentNamespace.getPrefix();
        }

        public void close() {
            this._currentNamespace = null;
            this._nextNamespace = this._namespaces.length;
        }
    }
}

