/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.rmi.Naming;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.handlers.SystemConfigFileHandler;
import org.openrdf.sesame.repository.SesameService;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPService;
import org.openrdf.sesame.server.rmi.FactoryInterface;
import org.openrdf.util.rmirouting.ChannelIfaceInvocation;

public class Sesame {
    public static LocalService getService() {
        return new LocalService();
    }

    public static LocalService getService(SystemConfig config) {
        return new LocalService(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalService getService(File systemConfigFile) throws IOException {
        FileInputStream in = new FileInputStream(systemConfigFile);
        try {
            SystemConfig sysConfig = SystemConfigFileHandler.readConfiguration(in);
            LocalService localService = Sesame.getService(sysConfig);
            return localService;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static HTTPService getService(URL serverURL) {
        return new HTTPService(serverURL);
    }

    public static SesameService getService(URI serverURI) {
        if (serverURI.getScheme().equals("rmi")) {
            String s = serverURI.toString();
            s = s.endsWith("/") ? s + "FactoryInterface" : s + "/FactoryInterface";
            try {
                FactoryInterface fi = (FactoryInterface)ChannelIfaceInvocation.wrapIt((Object)Naming.lookup(s));
                return fi.getService();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException("Unable to connect to Sesame service at '" + serverURI, t);
            }
        }
        throw new IllegalArgumentException("URI scheme not supported: " + serverURI.getScheme());
    }
}

