/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.dlib.tools.TextFileCallback;

public class TextFileLoader {
    private Vector vector = new Vector();
    private boolean loaded = false;
    private String errorMsg = null;
    private TextFileCallback callbackFnc = null;

    public TextFileLoader() {
    }

    public TextFileLoader(String string) {
        this.load(string);
    }

    public void load(String string) {
        this.loaded = false;
        this.vector.removeAllElements();
        try {
            BufferedReader bufferedReader;
            Object object;
            if (string.startsWith("http:")) {
                object = new URL(string);
                bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
            } else {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            while ((object = bufferedReader.readLine()) != null) {
                if (this.callbackFnc != null) {
                    this.callbackFnc.handleLine((String)object);
                    continue;
                }
                this.vector.addElement(object);
            }
            bufferedReader.close();
            this.loaded = true;
        }
        catch (IOException iOException) {
            this.errorMsg = iOException.getLocalizedMessage();
        }
    }

    public String getString() {
        if (this.vector.isEmpty()) {
            return null;
        }
        String string = "";
        for (int i = 0; i < this.vector.size(); ++i) {
            string = string + this.vector.elementAt(i) + "\n";
        }
        return string;
    }

    public String getRowAt(int n) {
        return (String)this.vector.elementAt(n);
    }

    public int getRows() {
        return this.vector.size();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public Enumeration elements() {
        return this.vector.elements();
    }

    public void setCallbackFnc(TextFileCallback textFileCallback) {
        this.callbackFnc = textFileCallback;
    }
}

