/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.dlib.gui.CustomLook;
import org.dlib.gui.FlexLayout;
import org.dlib.gui.TLabel;

public class TStatusBar
extends JPanel
implements Border {
    private FlexLayout flexL;
    private Vector vLabels = new Vector();

    public TStatusBar(int n) {
        this.flexL = new FlexLayout(n, 1);
        this.setLayout(this.flexL);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        for (int i = 0; i < n; ++i) {
            TLabel tLabel = new TLabel("", 0);
            tLabel.setBorder(this);
            tLabel.setFont(CustomLook.statusBarFont);
            this.add(i + ",0,x", tLabel);
            this.vLabels.addElement(tLabel);
        }
    }

    public void setSlotExpansion(int n, boolean bl) {
        this.flexL.setColProp(n, bl ? 1 : 0);
    }

    public JLabel getLabel(int n) {
        return (JLabel)this.vLabels.elementAt(n);
    }

    public void setText(int n, String string) {
        this.getLabel(n).setText(string);
    }

    public void setTooltip(int n, String string) {
        this.getLabel(n).setToolTipText(string);
    }

    public void setColor(int n, Color color) {
        this.getLabel(n).setForeground(color);
    }

    public void setLabel(int n, JLabel jLabel) {
        this.remove(this.getLabel(n));
        this.add(n + ",0,x", jLabel);
        this.vLabels.set(n, jLabel);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = Color.white;
        Color color2 = Color.gray;
        int n = this.getWidth() - 2;
        int n2 = this.getHeight() - 2;
        graphics.setColor(color2);
        graphics.drawRect(0, 0, n, n2);
        graphics.setColor(color);
        graphics.drawRect(1, 1, n, n2);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, n3 - 1, 0);
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(2, 2, 2, 2);
    }

    public boolean isBorderOpaque() {
        return true;
    }
}

