/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.Status;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class SnapshotStatusResponse
implements JsonpSerializable {
    private final List<Status> snapshots;
    public static final JsonpDeserializer<SnapshotStatusResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotStatusResponse::setupSnapshotStatusResponseDeserializer);

    private SnapshotStatusResponse(Builder builder) {
        this.snapshots = ApiTypeHelper.unmodifiableRequired(builder.snapshots, (Object)this, "snapshots");
    }

    public static SnapshotStatusResponse of(Function<Builder, ObjectBuilder<SnapshotStatusResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Status> snapshots() {
        return this.snapshots;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.snapshots)) {
            generator.writeKey("snapshots");
            generator.writeStartArray();
            for (Status item0 : this.snapshots) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSnapshotStatusResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::snapshots, JsonpDeserializer.arrayDeserializer(Status._DESERIALIZER), "snapshots");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotStatusResponse> {
        private List<Status> snapshots;

        public final Builder snapshots(List<Status> list) {
            this.snapshots = Builder._listAddAll(this.snapshots, list);
            return this;
        }

        public final Builder snapshots(Status value, Status ... values) {
            this.snapshots = Builder._listAdd(this.snapshots, value, values);
            return this;
        }

        public final Builder snapshots(Function<Status.Builder, ObjectBuilder<Status>> fn) {
            return this.snapshots(fn.apply(new Status.Builder()).build(), new Status[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotStatusResponse build() {
            this._checkSingleUse();
            return new SnapshotStatusResponse(this);
        }
    }
}

