/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch.security.QueryApiKeysResponse;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyAggregation;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQuery;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryApiKeysRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, ApiKeyAggregation> aggregations;
    @Nullable
    private final Integer from;
    @Nullable
    private final ApiKeyQuery query;
    private final List<FieldValue> searchAfter;
    @Nullable
    private final Integer size;
    private final List<SortOptions> sort;
    @Nullable
    private final Boolean withLimitedBy;
    @Nullable
    private final Boolean withProfileUid;
    public static final JsonpDeserializer<QueryApiKeysRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryApiKeysRequest::setupQueryApiKeysRequestDeserializer);
    public static final Endpoint<QueryApiKeysRequest, QueryApiKeysResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<QueryApiKeysRequest, QueryApiKeysResponse>("es/security.query_api_keys", request -> "POST", request -> "/_security/_query/api_key", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("typed_keys", "true");
        if (request.withProfileUid != null) {
            params.put("with_profile_uid", String.valueOf(request.withProfileUid));
        }
        if (request.withLimitedBy != null) {
            params.put("with_limited_by", String.valueOf(request.withLimitedBy));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, QueryApiKeysResponse._DESERIALIZER);

    private QueryApiKeysRequest(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.from = builder.from;
        this.query = builder.query;
        this.searchAfter = ApiTypeHelper.unmodifiable(builder.searchAfter);
        this.size = builder.size;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.withLimitedBy = builder.withLimitedBy;
        this.withProfileUid = builder.withProfileUid;
    }

    public static QueryApiKeysRequest of(Function<Builder, ObjectBuilder<QueryApiKeysRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, ApiKeyAggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final ApiKeyQuery query() {
        return this.query;
    }

    public final List<FieldValue> searchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Nullable
    public final Boolean withLimitedBy() {
        return this.withLimitedBy;
    }

    @Nullable
    public final Boolean withProfileUid() {
        return this.withProfileUid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, ApiKeyAggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.searchAfter)) {
            generator.writeKey("search_after");
            generator.writeStartArray();
            for (FieldValue fieldValue : this.searchAfter) {
                fieldValue.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions sortOptions : this.sort) {
                sortOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupQueryApiKeysRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(ApiKeyAggregation._DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from");
        op.add(Builder::query, ApiKeyQuery._DESERIALIZER, "query");
        op.add(Builder::searchAfter, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "search_after");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<QueryApiKeysRequest> {
        @Nullable
        private Map<String, ApiKeyAggregation> aggregations;
        @Nullable
        private Integer from;
        @Nullable
        private ApiKeyQuery query;
        @Nullable
        private List<FieldValue> searchAfter;
        @Nullable
        private Integer size;
        @Nullable
        private List<SortOptions> sort;
        @Nullable
        private Boolean withLimitedBy;
        @Nullable
        private Boolean withProfileUid;

        public final Builder aggregations(Map<String, ApiKeyAggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, ApiKeyAggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<ApiKeyAggregation.Builder, ObjectBuilder<ApiKeyAggregation>> fn) {
            return this.aggregations(key, fn.apply(new ApiKeyAggregation.Builder()).build());
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder query(@Nullable ApiKeyQuery value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<ApiKeyQuery.Builder, ObjectBuilder<ApiKeyQuery>> fn) {
            return this.query(fn.apply(new ApiKeyQuery.Builder()).build());
        }

        public final Builder searchAfter(List<FieldValue> list) {
            this.searchAfter = Builder._listAddAll(this.searchAfter, list);
            return this;
        }

        public final Builder searchAfter(FieldValue value, FieldValue ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, value, values);
            return this;
        }

        public final Builder searchAfter(String value, String ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (String v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.searchAfter = Builder._listAddAll(this.searchAfter, fieldValues);
            return this;
        }

        public final Builder searchAfter(long value, long ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (long v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.searchAfter = Builder._listAddAll(this.searchAfter, fieldValues);
            return this;
        }

        public final Builder searchAfter(double value, double ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (double v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.searchAfter = Builder._listAddAll(this.searchAfter, fieldValues);
            return this;
        }

        public final Builder searchAfter(boolean value, boolean ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (boolean v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.searchAfter = Builder._listAddAll(this.searchAfter, fieldValues);
            return this;
        }

        public final Builder searchAfter(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.searchAfter(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        public final Builder withLimitedBy(@Nullable Boolean value) {
            this.withLimitedBy = value;
            return this;
        }

        public final Builder withProfileUid(@Nullable Boolean value) {
            this.withProfileUid = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryApiKeysRequest build() {
            this._checkSingleUse();
            return new QueryApiKeysRequest(this);
        }
    }
}

