/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeInfoDiscover
implements JsonpSerializable {
    private final Map<String, JsonData> settings;
    private final List<String> seedHosts;
    @Nullable
    private final String type;
    private final List<String> seedProviders;
    public static final JsonpDeserializer<NodeInfoDiscover> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoDiscover::setupNodeInfoDiscoverDeserializer);

    private NodeInfoDiscover(Builder builder) {
        this.settings = ApiTypeHelper.unmodifiable(builder.settings);
        this.seedHosts = ApiTypeHelper.unmodifiable(builder.seedHosts);
        this.type = builder.type;
        this.seedProviders = ApiTypeHelper.unmodifiable(builder.seedProviders);
    }

    public static NodeInfoDiscover of(Function<Builder, ObjectBuilder<NodeInfoDiscover>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> settings() {
        return this.settings;
    }

    public final List<String> seedHosts() {
        return this.seedHosts;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    public final List<String> seedProviders() {
        return this.seedProviders;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> entry : this.settings.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.seedHosts)) {
            generator.writeKey("seed_hosts");
            generator.writeStartArray();
            for (String string : this.seedHosts) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
        if (ApiTypeHelper.isDefined(this.seedProviders)) {
            generator.writeKey("seed_providers");
            generator.writeStartArray();
            for (String string : this.seedProviders) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeInfoDiscoverDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::seedHosts, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "seed_hosts");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::seedProviders, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "seed_providers");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> builder.settings((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper)));
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeInfoDiscover> {
        @Nullable
        private Map<String, JsonData> settings = new HashMap<String, JsonData>();
        @Nullable
        private List<String> seedHosts;
        @Nullable
        private String type;
        @Nullable
        private List<String> seedProviders;

        public final Builder settings(Map<String, JsonData> map) {
            this.settings = Builder._mapPutAll(this.settings, map);
            return this;
        }

        public final Builder settings(String key, JsonData value) {
            this.settings = Builder._mapPut(this.settings, key, value);
            return this;
        }

        public final Builder seedHosts(List<String> list) {
            this.seedHosts = Builder._listAddAll(this.seedHosts, list);
            return this;
        }

        public final Builder seedHosts(String value, String ... values) {
            this.seedHosts = Builder._listAdd(this.seedHosts, value, values);
            return this;
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public final Builder seedProviders(List<String> list) {
            this.seedProviders = Builder._listAddAll(this.seedProviders, list);
            return this;
        }

        public final Builder seedProviders(String value, String ... values) {
            this.seedProviders = Builder._listAdd(this.seedProviders, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeInfoDiscover build() {
            this._checkSingleUse();
            return new NodeInfoDiscover(this);
        }
    }
}

