/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TokenizationConfig;
import co.elastic.clients.elasticsearch.ml.TokenizationConfigVariant;
import co.elastic.clients.elasticsearch.ml.TokenizationTruncate;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NlpRobertaTokenizationConfig
implements TokenizationConfigVariant,
JsonpSerializable {
    @Nullable
    private final Boolean addPrefixSpace;
    @Nullable
    private final Boolean withSpecialTokens;
    @Nullable
    private final Integer maxSequenceLength;
    @Nullable
    private final TokenizationTruncate truncate;
    @Nullable
    private final Integer span;
    public static final JsonpDeserializer<NlpRobertaTokenizationConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NlpRobertaTokenizationConfig::setupNlpRobertaTokenizationConfigDeserializer);

    private NlpRobertaTokenizationConfig(Builder builder) {
        this.addPrefixSpace = builder.addPrefixSpace;
        this.withSpecialTokens = builder.withSpecialTokens;
        this.maxSequenceLength = builder.maxSequenceLength;
        this.truncate = builder.truncate;
        this.span = builder.span;
    }

    public static NlpRobertaTokenizationConfig of(Function<Builder, ObjectBuilder<NlpRobertaTokenizationConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizationConfig.Kind _tokenizationConfigKind() {
        return TokenizationConfig.Kind.Roberta;
    }

    @Nullable
    public final Boolean addPrefixSpace() {
        return this.addPrefixSpace;
    }

    @Nullable
    public final Boolean withSpecialTokens() {
        return this.withSpecialTokens;
    }

    @Nullable
    public final Integer maxSequenceLength() {
        return this.maxSequenceLength;
    }

    @Nullable
    public final TokenizationTruncate truncate() {
        return this.truncate;
    }

    @Nullable
    public final Integer span() {
        return this.span;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.addPrefixSpace != null) {
            generator.writeKey("add_prefix_space");
            generator.write(this.addPrefixSpace.booleanValue());
        }
        if (this.withSpecialTokens != null) {
            generator.writeKey("with_special_tokens");
            generator.write(this.withSpecialTokens.booleanValue());
        }
        if (this.maxSequenceLength != null) {
            generator.writeKey("max_sequence_length");
            generator.write(this.maxSequenceLength.intValue());
        }
        if (this.truncate != null) {
            generator.writeKey("truncate");
            this.truncate.serialize(generator, mapper);
        }
        if (this.span != null) {
            generator.writeKey("span");
            generator.write(this.span.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNlpRobertaTokenizationConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::addPrefixSpace, JsonpDeserializer.booleanDeserializer(), "add_prefix_space");
        op.add(Builder::withSpecialTokens, JsonpDeserializer.booleanDeserializer(), "with_special_tokens");
        op.add(Builder::maxSequenceLength, JsonpDeserializer.integerDeserializer(), "max_sequence_length");
        op.add(Builder::truncate, TokenizationTruncate._DESERIALIZER, "truncate");
        op.add(Builder::span, JsonpDeserializer.integerDeserializer(), "span");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NlpRobertaTokenizationConfig> {
        @Nullable
        private Boolean addPrefixSpace;
        @Nullable
        private Boolean withSpecialTokens;
        @Nullable
        private Integer maxSequenceLength;
        @Nullable
        private TokenizationTruncate truncate;
        @Nullable
        private Integer span;

        public final Builder addPrefixSpace(@Nullable Boolean value) {
            this.addPrefixSpace = value;
            return this;
        }

        public final Builder withSpecialTokens(@Nullable Boolean value) {
            this.withSpecialTokens = value;
            return this;
        }

        public final Builder maxSequenceLength(@Nullable Integer value) {
            this.maxSequenceLength = value;
            return this;
        }

        public final Builder truncate(@Nullable TokenizationTruncate value) {
            this.truncate = value;
            return this;
        }

        public final Builder span(@Nullable Integer value) {
            this.span = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NlpRobertaTokenizationConfig build() {
            this._checkSingleUse();
            return new NlpRobertaTokenizationConfig(this);
        }
    }
}

