/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.put_index_template;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.DataStreamLifecycle;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexTemplateMapping
implements JsonpSerializable {
    private final Map<String, Alias> aliases;
    @Nullable
    private final TypeMapping mappings;
    @Nullable
    private final IndexSettings settings;
    @Nullable
    private final DataStreamLifecycle lifecycle;
    public static final JsonpDeserializer<IndexTemplateMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexTemplateMapping::setupIndexTemplateMappingDeserializer);

    private IndexTemplateMapping(Builder builder) {
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.mappings = builder.mappings;
        this.settings = builder.settings;
        this.lifecycle = builder.lifecycle;
    }

    public static IndexTemplateMapping of(Function<Builder, ObjectBuilder<IndexTemplateMapping>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Alias> aliases() {
        return this.aliases;
    }

    @Nullable
    public final TypeMapping mappings() {
        return this.mappings;
    }

    @Nullable
    public final IndexSettings settings() {
        return this.settings;
    }

    @Nullable
    public final DataStreamLifecycle lifecycle() {
        return this.lifecycle;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry<String, Alias> item0 : this.aliases.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        if (this.lifecycle != null) {
            generator.writeKey("lifecycle");
            this.lifecycle.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndexTemplateMappingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
        op.add(Builder::settings, IndexSettings._DESERIALIZER, "settings");
        op.add(Builder::lifecycle, DataStreamLifecycle._DESERIALIZER, "lifecycle");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexTemplateMapping> {
        @Nullable
        private Map<String, Alias> aliases;
        @Nullable
        private TypeMapping mappings;
        @Nullable
        private IndexSettings settings;
        @Nullable
        private DataStreamLifecycle lifecycle;

        public final Builder aliases(Map<String, Alias> map) {
            this.aliases = Builder._mapPutAll(this.aliases, map);
            return this;
        }

        public final Builder aliases(String key, Alias value) {
            this.aliases = Builder._mapPut(this.aliases, key, value);
            return this;
        }

        public final Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(key, fn.apply(new Alias.Builder()).build());
        }

        public final Builder mappings(@Nullable TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public final Builder settings(@Nullable IndexSettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(fn.apply(new IndexSettings.Builder()).build());
        }

        public final Builder lifecycle(@Nullable DataStreamLifecycle value) {
            this.lifecycle = value;
            return this;
        }

        public final Builder lifecycle(Function<DataStreamLifecycle.Builder, ObjectBuilder<DataStreamLifecycle>> fn) {
            return this.lifecycle(fn.apply(new DataStreamLifecycle.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexTemplateMapping build() {
            this._checkSingleUse();
            return new IndexTemplateMapping(this);
        }
    }
}

