/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.CompletionContext;
import co.elastic.clients.elasticsearch.core.search.FieldSuggester;
import co.elastic.clients.elasticsearch.core.search.FieldSuggesterVariant;
import co.elastic.clients.elasticsearch.core.search.RegexOptions;
import co.elastic.clients.elasticsearch.core.search.SuggestFuzziness;
import co.elastic.clients.elasticsearch.core.search.SuggesterBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompletionSuggester
extends SuggesterBase
implements FieldSuggesterVariant {
    private final Map<String, List<CompletionContext>> contexts;
    @Nullable
    private final SuggestFuzziness fuzzy;
    @Nullable
    private final RegexOptions regex;
    @Nullable
    private final Boolean skipDuplicates;
    public static final JsonpDeserializer<CompletionSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompletionSuggester::setupCompletionSuggesterDeserializer);

    private CompletionSuggester(Builder builder) {
        super(builder);
        this.contexts = ApiTypeHelper.unmodifiable(builder.contexts);
        this.fuzzy = builder.fuzzy;
        this.regex = builder.regex;
        this.skipDuplicates = builder.skipDuplicates;
    }

    public static CompletionSuggester of(Function<Builder, ObjectBuilder<CompletionSuggester>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FieldSuggester.Kind _fieldSuggesterKind() {
        return FieldSuggester.Kind.Completion;
    }

    public final Map<String, List<CompletionContext>> contexts() {
        return this.contexts;
    }

    @Nullable
    public final SuggestFuzziness fuzzy() {
        return this.fuzzy;
    }

    @Nullable
    public final RegexOptions regex() {
        return this.regex;
    }

    @Nullable
    public final Boolean skipDuplicates() {
        return this.skipDuplicates;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.contexts)) {
            generator.writeKey("contexts");
            generator.writeStartObject();
            for (Map.Entry<String, List<CompletionContext>> item0 : this.contexts.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (CompletionContext item1 : item0.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.fuzzy != null) {
            generator.writeKey("fuzzy");
            this.fuzzy.serialize(generator, mapper);
        }
        if (this.regex != null) {
            generator.writeKey("regex");
            this.regex.serialize(generator, mapper);
        }
        if (this.skipDuplicates != null) {
            generator.writeKey("skip_duplicates");
            generator.write(this.skipDuplicates.booleanValue());
        }
    }

    protected static void setupCompletionSuggesterDeserializer(ObjectDeserializer<Builder> op) {
        SuggesterBase.setupSuggesterBaseDeserializer(op);
        op.add(Builder::contexts, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(CompletionContext._DESERIALIZER)), "contexts");
        op.add(Builder::fuzzy, SuggestFuzziness._DESERIALIZER, "fuzzy");
        op.add(Builder::regex, RegexOptions._DESERIALIZER, "regex");
        op.add(Builder::skipDuplicates, JsonpDeserializer.booleanDeserializer(), "skip_duplicates");
    }

    public static class Builder
    extends SuggesterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CompletionSuggester> {
        @Nullable
        private Map<String, List<CompletionContext>> contexts;
        @Nullable
        private SuggestFuzziness fuzzy;
        @Nullable
        private RegexOptions regex;
        @Nullable
        private Boolean skipDuplicates;

        public final Builder contexts(Map<String, List<CompletionContext>> map) {
            this.contexts = Builder._mapPutAll(this.contexts, map);
            return this;
        }

        public final Builder contexts(String key, List<CompletionContext> value) {
            this.contexts = Builder._mapPut(this.contexts, key, value);
            return this;
        }

        public final Builder fuzzy(@Nullable SuggestFuzziness value) {
            this.fuzzy = value;
            return this;
        }

        public final Builder fuzzy(Function<SuggestFuzziness.Builder, ObjectBuilder<SuggestFuzziness>> fn) {
            return this.fuzzy(fn.apply(new SuggestFuzziness.Builder()).build());
        }

        public final Builder regex(@Nullable RegexOptions value) {
            this.regex = value;
            return this;
        }

        public final Builder regex(Function<RegexOptions.Builder, ObjectBuilder<RegexOptions>> fn) {
            return this.regex(fn.apply(new RegexOptions.Builder()).build());
        }

        public final Builder skipDuplicates(@Nullable Boolean value) {
            this.skipDuplicates = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompletionSuggester build() {
            this._checkSingleUse();
            return new CompletionSuggester(this);
        }
    }
}

