/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoBoundsAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Boolean wrapLongitude;
    public static final JsonpDeserializer<GeoBoundsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoBoundsAggregation::setupGeoBoundsAggregationDeserializer);

    private GeoBoundsAggregation(Builder builder) {
        super(builder);
        this.wrapLongitude = builder.wrapLongitude;
    }

    public static GeoBoundsAggregation of(Function<Builder, ObjectBuilder<GeoBoundsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeoBounds;
    }

    @Nullable
    public final Boolean wrapLongitude() {
        return this.wrapLongitude;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.wrapLongitude != null) {
            generator.writeKey("wrap_longitude");
            generator.write(this.wrapLongitude.booleanValue());
        }
    }

    protected static void setupGeoBoundsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::wrapLongitude, JsonpDeserializer.booleanDeserializer(), "wrap_longitude");
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoBoundsAggregation> {
        @Nullable
        private Boolean wrapLongitude;

        public final Builder wrapLongitude(@Nullable Boolean value) {
            this.wrapLongitude = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoBoundsAggregation build() {
            this._checkSingleUse();
            return new GeoBoundsAggregation(this);
        }
    }
}

