/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.GeoBounds;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoBoundsAggregate
extends AggregateBase
implements AggregateVariant {
    @Nullable
    private final GeoBounds bounds;
    public static final JsonpDeserializer<GeoBoundsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoBoundsAggregate::setupGeoBoundsAggregateDeserializer);

    private GeoBoundsAggregate(Builder builder) {
        super(builder);
        this.bounds = builder.bounds;
    }

    public static GeoBoundsAggregate of(Function<Builder, ObjectBuilder<GeoBoundsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.GeoBounds;
    }

    @Nullable
    public final GeoBounds bounds() {
        return this.bounds;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bounds != null) {
            generator.writeKey("bounds");
            this.bounds.serialize(generator, mapper);
        }
    }

    protected static void setupGeoBoundsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::bounds, GeoBounds._DESERIALIZER, "bounds");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoBoundsAggregate> {
        @Nullable
        private GeoBounds bounds;

        public final Builder bounds(@Nullable GeoBounds value) {
            this.bounds = value;
            return this;
        }

        public final Builder bounds(Function<GeoBounds.Builder, ObjectBuilder<GeoBounds>> fn) {
            return this.bounds(fn.apply(new GeoBounds.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoBoundsAggregate build() {
            this._checkSingleUse();
            return new GeoBoundsAggregate(this);
        }
    }
}

