/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw.services.getrecords;

import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.kernel.csw.CatalogConfiguration;
import org.fao.geonet.kernel.csw.services.getrecords.IFieldMapper;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

public class SortByParser {
    @Autowired
    IFieldMapper fieldMapper;
    @Autowired
    private CatalogConfiguration _catalogConfig;

    public List<SortOptions> parseSortBy(Element request) {
        Element query = request.getChild("Query", Csw.NAMESPACE_CSW);
        if (query == null) {
            return this.getDefaultSort();
        }
        Element sortBy = query.getChild("SortBy", Csw.NAMESPACE_OGC);
        if (sortBy == null) {
            return this.getDefaultSort();
        }
        List<SortOptions> sortFields = new ArrayList<SortOptions>();
        List list = sortBy.getChildren();
        for (Element el : list) {
            String esSortFieldName = this.getEsSortFieldName(el);
            if (StringUtils.isEmpty((String)esSortFieldName)) continue;
            SortOrder esSortOrder = this.getEsSortOrder(el);
            SortOptions sortFieldOptions = (SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(esSortFieldName).order(esSortOrder).build()).build();
            sortFields.add(sortFieldOptions);
        }
        if (sortFields.size() == 0) {
            sortFields = this.getDefaultSort();
        }
        return sortFields;
    }

    private List<SortOptions> getDefaultSort() {
        ArrayList<SortOptions> sortFields = new ArrayList<SortOptions>();
        SortOptions defaultSortField = SortOptions.of(b -> b.field(fb -> fb.field(this._catalogConfig.getDefaultSortField()).order(this._catalogConfig.getDefaultSortOrder().equals("DESC") ? SortOrder.Desc : SortOrder.Asc)));
        sortFields.add(defaultSortField);
        return sortFields;
    }

    private String getEsSortFieldName(Element el) {
        String cswField = el.getChildText("PropertyName", Csw.NAMESPACE_OGC);
        if (cswField == null) {
            return null;
        }
        String matchingEsFieldOrEmpty = this.fieldMapper.mapSort(cswField);
        if (StringUtils.isEmpty((String)matchingEsFieldOrEmpty) && cswField.toLowerCase().equals("relevance")) {
            return "_score";
        }
        return matchingEsFieldOrEmpty;
    }

    private SortOrder getEsSortOrder(Element el) {
        String order = el.getChildText("SortOrder", Csw.NAMESPACE_OGC);
        boolean isDescOrder = "DESC".equals(order);
        return isDescOrder ? SortOrder.Desc : SortOrder.Asc;
    }
}

