/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml311;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LineTypeType implements Enumerator
{
    STRAIGHT(0, "STRAIGHT", "STRAIGHT"),
    BENT(1, "BENT", "BENT");

    public static final int STRAIGHT_VALUE = 0;
    public static final int BENT_VALUE = 1;
    private static final LineTypeType[] VALUES_ARRAY;
    public static final List<LineTypeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static LineTypeType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LineTypeType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static LineTypeType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LineTypeType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static LineTypeType get(int value) {
        switch (value) {
            case 0: {
                return STRAIGHT;
            }
            case 1: {
                return BENT;
            }
        }
        return null;
    }

    private LineTypeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new LineTypeType[]{STRAIGHT, BENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

