/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import com.google.common.base.Function;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.fao.geonet.exceptions.BadSoapResponseEx;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.SOAPUtil;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.http.client.ClientHttpResponse;

public class AbstractHttpRequest {
    protected final GeonetHttpRequestFactory requestFactory;
    protected String host;
    protected int port;
    protected String protocol;
    protected boolean useSOAP;
    protected String sentData;
    private String address;
    private String query;
    private Method method;
    private Element postParams;
    private boolean useProxy;
    private String proxyHost;
    private int proxyPort;
    private ArrayList<NameValuePair> alSimpleParams = new ArrayList();
    private String postData;
    private boolean preemptiveBasicAuth;
    private HttpClientContext httpClientContext;
    private CookieStore cookieStore;
    private UsernamePasswordCredentials credentials;
    private UsernamePasswordCredentials proxyCredentials;
    private String fragment;
    private String userInfo;

    public AbstractHttpRequest(String protocol, String host, int port, GeonetHttpRequestFactory requestFactory) {
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new IllegalArgumentException("Currently only http and https requests are supported.  Protocol given: '" + protocol + "'");
        }
        this.port = port;
        this.protocol = protocol;
        this.requestFactory = requestFactory;
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        if (!address.startsWith("/")) {
            throw new IllegalArgumentException("address must start with /");
        }
        this.address = address;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method m) {
        this.method = m;
    }

    public String getSentData() {
        return this.sentData;
    }

    public void setUrl(URL url) {
        this.host = url.getHost();
        this.port = url.getPort();
        this.protocol = url.getProtocol();
        this.address = url.getPath();
        this.query = url.getQuery();
    }

    public void setUseSOAP(boolean yesno) {
        this.useSOAP = yesno;
    }

    public void setUseProxy(boolean yesno) {
        this.useProxy = yesno;
    }

    public void setProxyHost(String host) {
        this.proxyHost = host;
    }

    public void setProxyPort(int port) {
        this.proxyPort = port;
    }

    public void setProxyCredentials(String username, String password) {
        if (username == null || username.trim().length() == 0) {
            return;
        }
        this.proxyCredentials = new UsernamePasswordCredentials(username, password);
    }

    public void clearParams() {
        this.alSimpleParams.clear();
        this.postParams = null;
    }

    public void addParam(String name, Object value) {
        if (value != null) {
            this.alSimpleParams.add((NameValuePair)new BasicNameValuePair(name, value.toString()));
        }
        this.method = Method.GET;
    }

    public void setRequest(Element request) {
        this.postParams = (Element)request.detach();
        this.method = Method.POST;
    }

    public boolean isPreemptiveBasicAuth() {
        return this.preemptiveBasicAuth;
    }

    public void setPreemptiveBasicAuth(boolean preemptiveBasicAuth) {
        this.preemptiveBasicAuth = preemptiveBasicAuth;
    }

    public HttpClientContext getHttpClientContext() {
        return this.httpClientContext;
    }

    public void setCredentials(String username, String password) {
        this.credentials = new UsernamePasswordCredentials(username, password);
    }

    protected ClientHttpResponse doExecute(final HttpRequestBase httpMethod) throws IOException {
        return this.requestFactory.execute((HttpUriRequest)httpMethod, new Function<HttpClientBuilder, Void>(){

            @Nullable
            public Void apply(@Nonnull HttpClientBuilder input) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                if (AbstractHttpRequest.this.credentials != null) {
                    URI uri = httpMethod.getURI();
                    HttpHost hh = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                    credentialsProvider.setCredentials(new AuthScope(hh), (Credentials)AbstractHttpRequest.this.credentials);
                    if (AbstractHttpRequest.this.isPreemptiveBasicAuth()) {
                        BasicAuthCache authCache = new BasicAuthCache();
                        BasicScheme basicAuth = new BasicScheme();
                        authCache.put(hh, (AuthScheme)basicAuth);
                        AbstractHttpRequest.this.httpClientContext = HttpClientContext.create();
                        AbstractHttpRequest.this.httpClientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                        AbstractHttpRequest.this.httpClientContext.setAuthCache((AuthCache)authCache);
                    } else {
                        input.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                    }
                } else {
                    input.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                if (AbstractHttpRequest.this.useProxy) {
                    HttpHost proxy = new HttpHost(AbstractHttpRequest.this.proxyHost, AbstractHttpRequest.this.proxyPort);
                    input.setProxy(proxy);
                    if (AbstractHttpRequest.this.proxyCredentials != null) {
                        credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)AbstractHttpRequest.this.proxyCredentials);
                    }
                }
                input.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
                return null;
            }
        }, this);
    }

    protected HttpRequestBase setupHttpMethod() throws IOException {
        HttpGet httpMethod;
        String queryString = this.query;
        if (this.query == null || this.query.trim().isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (NameValuePair alSimpleParam : this.alSimpleParams) {
                if (b.length() > 0) {
                    b.append("&");
                }
                b.append(alSimpleParam.getName()).append('=').append(alSimpleParam.getValue());
            }
            if (b.length() > 0) {
                queryString = b.toString();
            }
        }
        if (this.host == null || this.protocol == null) {
            throw new IllegalStateException(String.format("%s is not ready to be executed: \n\tprotocol: '%s' \n\tuserinfo: '%s'\n\thost: '%s' \n\tport: '%s' \n\taddress: '%s'\n\tquery '%s'\n\tfragment: '%s'", this.getClass().getSimpleName(), this.protocol, this.userInfo, this.host, this.port, this.address, this.query, this.fragment));
        }
        if (this.method == Method.GET) {
            HttpGet get = new HttpGet();
            get.addHeader("Accept", !this.useSOAP ? "application/xml" : "application/soap+xml");
            httpMethod = get;
        } else {
            StringEntity entity;
            HttpPost post = new HttpPost();
            if (!this.useSOAP) {
                this.postData = this.postParams == null ? "" : Xml.getString(new Document(this.postParams));
                entity = new StringEntity(this.postData, ContentType.create((String)"application/xml", (String)"UTF-8"));
                post.setEntity((HttpEntity)entity);
            } else {
                this.postData = Xml.getString(new Document(this.soapEmbed(this.postParams)));
                entity = new StringEntity(this.postData, ContentType.create((String)"application/xml", (String)"UTF-8"));
                post.setEntity((HttpEntity)entity);
            }
            httpMethod = post;
        }
        try {
            URI uri = new URI(this.protocol, this.userInfo, this.host, this.port, this.address, queryString, this.fragment);
            httpMethod.setURI(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setAuthenticationEnabled(this.credentials != null || this.proxyCredentials != null);
        builder.setRedirectsEnabled(true);
        builder.setRelativeRedirectsAllowed(true);
        builder.setCircularRedirectsAllowed(true);
        builder.setMaxRedirects(3);
        builder.setCookieSpec("compatibility");
        httpMethod.setConfig(builder.build());
        return httpMethod;
    }

    protected String getSentData(HttpRequestBase httpMethod) {
        URI uri = httpMethod.getURI();
        StringBuilder sentDataValue = new StringBuilder(httpMethod.getMethod()).append(" ").append(uri.getPath());
        if (uri.getQuery() != null) {
            sentDataValue.append("?" + uri.getQuery());
        }
        sentDataValue.append("\r\n");
        for (Header h : httpMethod.getAllHeaders()) {
            sentDataValue.append(h);
        }
        sentDataValue.append("\r\n");
        if (httpMethod instanceof HttpPost) {
            sentDataValue.append(this.postData);
        }
        return sentDataValue.toString();
    }

    private Element soapEmbed(Element elem) {
        Element envl = new Element("Envelope", SOAPUtil.NAMESPACE_ENV);
        Element body = new Element("Body", SOAPUtil.NAMESPACE_ENV);
        envl.addContent((Content)body);
        body.addContent((Content)elem);
        return envl;
    }

    protected Element soapUnembed(Element envelope) throws BadSoapResponseEx {
        Namespace ns = envelope.getNamespace();
        Element body = envelope.getChild("Body", ns);
        if (body == null) {
            throw new BadSoapResponseEx(envelope);
        }
        List list = body.getChildren();
        if (list.isEmpty()) {
            throw new BadSoapResponseEx(envelope);
        }
        return (Element)list.get(0);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        HttpClientContext context = this.getHttpClientContext();
        if (context == null) {
            this.httpClientContext = HttpClientContext.create();
        }
        this.httpClientContext.setAttribute("http.cookie-store", (Object)cookieStore);
    }

    public static enum Method {
        GET,
        POST;

    }
}

