/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.camelPeriodicProducer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.records.MetadataSavedQueryApi;
import org.fao.geonet.camelPeriodicProducer.MessageProducer;
import org.fao.geonet.camelPeriodicProducer.MessageProducerFactory;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MessageProducerEntity;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.events.server.ServerStartup;
import org.fao.geonet.harvester.wfsfeatures.model.WFSHarvesterParameter;
import org.fao.geonet.harvester.wfsfeatures.worker.WFSHarvesterExchangeState;
import org.fao.geonet.repository.MessageProducerRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class MessageProducerService
implements ApplicationListener<ServerStartup> {
    private static final String DEFAULT_CONSUMER_URI = "activemq://queue:harvest-wfs-features?concurrentConsumers=5";
    private static Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.harvest.wfs.features");
    private static boolean isConfigured = false;
    protected String consumerUri = "activemq://queue:harvest-wfs-features?concurrentConsumers=5";
    @Autowired
    protected MessageProducerFactory messageProducerFactory;
    @Autowired
    protected MessageProducerRepository msgProducerRepository;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    MetadataSavedQueryApi savedQueryApi;

    public MessageProducerService() {
    }

    public MessageProducerService(MetadataRepository metadataRepository, MetadataSavedQueryApi savedQueryApi) {
        this.metadataRepository = metadataRepository;
        this.savedQueryApi = savedQueryApi;
    }

    public void onApplicationEvent(ServerStartup serverStartup) {
        this.configure();
    }

    public synchronized void configure() {
        if (!isConfigured) {
            this.msgProducerRepository.findAll().stream().filter(messageProducerEntity -> StringUtils.isNotEmpty((String)messageProducerEntity.getCronExpression())).forEach(messageProducerEntity -> {
                try {
                    this.messageProducerFactory.registerAndStart(this.buildWfsHarvesterParameterMessageProducer((MessageProducerEntity)messageProducerEntity));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to initialise persisted quartz wfs harvester command messages producer, id: ({}).", (Object)messageProducerEntity.getId());
                }
            });
            isConfigured = true;
        }
    }

    public void changeMessageAndReschedule(MessageProducerEntity messageProducerEntity) throws Exception {
        this.messageProducerFactory.changeMessageAndReschedule(this.buildWfsHarvesterParameterMessageProducer(messageProducerEntity));
    }

    public void registerAndStart(MessageProducerEntity messageProducerEntity) throws Exception {
        this.messageProducerFactory.registerAndStart(this.buildWfsHarvesterParameterMessageProducer(messageProducerEntity));
    }

    public void destroy(long id) throws Exception {
        this.messageProducerFactory.destroy(id);
    }

    private MessageProducer<WFSHarvesterExchangeState> buildWfsHarvesterParameterMessageProducer(MessageProducerEntity messageProducerEntity) {
        String metadataUuid = messageProducerEntity.getWfsHarvesterParam().getMetadataUuid();
        String typeName = messageProducerEntity.getWfsHarvesterParam().getTypeName();
        WFSHarvesterParameter wfsHarvesterParam = new WFSHarvesterParameter(messageProducerEntity.getWfsHarvesterParam().getUrl(), typeName, metadataUuid);
        try {
            Map<String, Object> applicationProfile = this.getApplicationProfile(metadataUuid, typeName);
            if (applicationProfile != null) {
                wfsHarvesterParam.setTreeFields(this.getTreeField(applicationProfile));
                wfsHarvesterParam.setTokenizedFields(this.getTokenizedField(applicationProfile));
            }
        }
        catch (Exception e) {
            LOGGER.info("Could not fetch tree field and tokenized field for metadata uuid {} and typename {}", (Object)metadataUuid, (Object)typeName);
        }
        return new MessageProducer<WFSHarvesterExchangeState>().setMessage(new WFSHarvesterExchangeState(wfsHarvesterParam)).setCronExpession(messageProducerEntity.getCronExpression()).setTarget(this.consumerUri).setId(messageProducerEntity.getId());
    }

    public List<String> getTreeField(Map<String, Object> map) {
        return (List)map.get("treeFields");
    }

    public Map<String, String> getTokenizedField(Map<String, Object> map) {
        return (Map)map.get("tokenizedFields");
    }

    private Map<String, Object> getApplicationProfile(String metadataUuid, String typeName) {
        try {
            Metadata metadata = this.metadataRepository.findOneByUuid(metadataUuid);
            if (metadata != null) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("protocol", "WFS");
                params.put("name", typeName);
                Map wfsConfig = this.savedQueryApi.query((AbstractMetadata)metadata, "wfs-indexing-config", params);
                if (wfsConfig.size() > 0 && StringUtils.isNotEmpty((String)((String)wfsConfig.get("0")))) {
                    ObjectReader reader = new ObjectMapper().readerFor(Map.class);
                    return (Map)reader.readValue((String)wfsConfig.get("0"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

