/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.RecordBuilder;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jzkit.search.util.RecordBuilder.RecordBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Service(value="org.jzkit.recordbuilder.string")
public class StringRecordFactory
implements RecordBuilder,
ApplicationContextAware,
ApplicationListener,
Serializable {
    private static Log log = LogFactory.getLog(StringRecordFactory.class);
    private ApplicationContext ctx = null;

    public Object createFrom(Document input_dom, String esn) {
        String result = null;
        try {
            if (input_dom.getDocumentElement().getTagName().equals("string")) {
                result = input_dom.getDocumentElement().getFirstChild().getNodeValue();
            } else {
                OutputFormat format = new OutputFormat("xml", "utf-8", false);
                format.setOmitXMLDeclaration(true);
                StringWriter stringOut = new StringWriter();
                XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
                serial.setNamespaces(true);
                serial.asDOMSerializer();
                serial.serialize(input_dom.getDocumentElement());
                result = stringOut.toString();
            }
        }
        catch (IOException ioe) {
            log.error((Object)"Problem", (Throwable)ioe);
        }
        return result;
    }

    public Document getCanonicalXML(Object native_object) {
        Document retval = null;
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            dfactory.setValidating(false);
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            retval = docBuilder.newDocument();
            Element root = retval.createElement("text");
            root.appendChild(retval.createTextNode(native_object.toString()));
            retval.appendChild(root);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        return retval;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void onApplicationEvent(ApplicationEvent evt) {
    }
}

