/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.feedback;

import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.services.Utils;
import org.fao.geonet.utils.BinaryFile;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

public class AddLimitations
implements Service {
    private final SimpleDateFormat _dateFormat = AddLimitations.createDateFormatter();
    private Path stylePath;

    protected static void addElement(Element root, String name, String value) {
        root.addContent((Content)new Element(name).setText(value));
    }

    private static String now() {
        Calendar cal = Calendar.getInstance();
        return AddLimitations.createDateFormatter().format(cal.getTime());
    }

    private static SimpleDateFormat createDateFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.stylePath = appPath.resolve("xsl");
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        Optional user;
        String id = Utils.getIdentifierFromParameters((Element)params, (ServiceContext)context);
        String access = Util.getParam((Element)params, (String)"access");
        Lib.resource.checkPrivilege(context, id, ReservedOperation.download);
        AbstractMetadata info = ((IMetadataUtils)context.getBean(IMetadataUtils.class)).findOne(id);
        if (info == null) {
            throw new IllegalArgumentException("Metadata not found --> " + id);
        }
        Element response = new Element("response");
        AddLimitations.addElement(response, "id", id);
        AddLimitations.addElement(response, "uuid", info.getUuid());
        Element downloaded = new Element("downloaded");
        Store store = (Store)context.getBean("resourceStore", Store.class);
        List files = params.getChildren("fname");
        for (Element elem : files) {
            response.addContent((Content)((Element)elem.clone()));
            String fname = elem.getText();
            try {
                FilePathChecker.verify((String)fname);
            }
            catch (Exception ex) {
                continue;
            }
            Element fileInfo = new Element("file");
            try (Store.ResourceHolder resource = store.getResource(context, info.getUuid(), fname);){
                BinaryFile bFile = BinaryFile.encode((int)200, (Path)resource.getPath(), (boolean)false);
                Element details = bFile.getElement();
                String remoteURL = details.getAttributeValue("remotepath");
                if (remoteURL != null) {
                    fileInfo.setAttribute("size", "unknown");
                    fileInfo.setAttribute("datemodified", "unknown");
                    fileInfo.setAttribute("name", remoteURL);
                } else {
                    fileInfo.setAttribute("size", "" + resource.getMetadata().getSize());
                    fileInfo.setAttribute("name", fname);
                    fileInfo.setAttribute("datemodified", this._dateFormat.format(resource.getMetadata().getLastModification()));
                }
            }
            downloaded.addContent((Content)fileInfo);
        }
        AddLimitations.addElement(response, "access", access);
        boolean forEditing = false;
        boolean withValidationErrors = false;
        boolean keepXlinkAttributes = false;
        DataManager dataManager = (DataManager)context.getBean(DataManager.class);
        Element elMd = dataManager.getMetadata(context, id, forEditing, withValidationErrors, keepXlinkAttributes);
        if (elMd == null) {
            throw new IllegalArgumentException("Metadata not found --> " + id);
        }
        Element md = new Element("metadata");
        md.addContent((Content)((Element)elMd.clone()));
        response.addContent((Content)md);
        Path briefXslt = this.stylePath.resolve("metadata-brief.xsl");
        Element elBrief = Xml.transform((Element)elMd, (Path)briefXslt);
        Element root = new Element("root");
        elBrief.setAttribute("changedate", info.getDataInfo().getChangeDate().getDateAndTime());
        elBrief.setAttribute("currdate", AddLimitations.now());
        root.addContent((Content)elBrief);
        root.addContent((Content)downloaded);
        if (context.isDebugEnabled()) {
            context.debug("Passed to metadata-license-annex.xsl:\n " + Xml.getString((Element)root));
        }
        Path licenseAnnexXslt = this.stylePath.resolve("metadata-license-annex.xsl");
        Element license = Xml.transform((Element)root, (Path)licenseAnnexXslt);
        response.addContent((Content)new Element("license").addContent((Content)license));
        UserSession session = context.getUserSession();
        Element resourceData = (Element)session.getProperty("file.disclaimer");
        if (resourceData == null) {
            resourceData = new Element("file.disclaimer");
            AddLimitations.addElement(resourceData, "id", id);
        } else {
            Element idEl = resourceData.getChild("id");
            if (idEl == null) {
                AddLimitations.addElement(resourceData, "id", id);
            } else {
                idEl.setText(id);
            }
        }
        session.setProperty("file.disclaimer", (Object)resourceData);
        if (session.getUserId() != null && (user = ((UserRepository)context.getBean(UserRepository.class)).findById((Object)session.getUserIdAsInt())).isPresent()) {
            Element elRec = ((User)user.get()).asXml();
            elBrief.setName("record");
            response.addContent((Collection)elRec.cloneContent());
        }
        return response;
    }
}

