/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.userfeedback;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.jcs.access.exception.ObjectNotFoundException;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.api.userfeedback.UserFeedbackDTO;
import org.fao.geonet.api.userfeedback.UserFeedbackUtils;
import org.fao.geonet.api.userfeedback.service.IUserFeedbackService;
import org.fao.geonet.api.users.recaptcha.RecaptchaChecker;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.StatusValueNotificationLevel;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.userfeedback.RatingCriteria;
import org.fao.geonet.domain.userfeedback.UserFeedback;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.metadata.DefaultStatusActions;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.FeedbackLanguages;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.userfeedback.RatingCriteriaRepository;
import org.fao.geonet.util.LocalizedEmail;
import org.fao.geonet.util.LocalizedEmailComponent;
import org.fao.geonet.util.LocalizedEmailParameter;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api"})
@Tag(name="userfeedback", description="User feedback")
@Controller(value="userfeedback")
public class UserFeedbackAPI {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    SettingManager settingManager;
    @Autowired
    RatingCriteriaRepository criteriaRepository;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    FeedbackLanguages feedbackLanguages;

    @Operation(summary="Get list of rating criteria")
    @RequestMapping(value={"/userfeedback/ratingcriteria"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<RatingCriteria> getRatingCriteria(@Parameter(hidden=true) HttpServletResponse response) {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            return null;
        }
        return this.criteriaRepository.findAll();
    }

    @Operation(summary="Removes a user feedback", description="Removes a user feedback")
    @RequestMapping(value={"/userfeedback/{uuid}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="User feedback removed.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Operation not allowed. Only Reviewvers can access it.")})
    @ResponseBody
    public ResponseEntity deleteUserFeedback(@Parameter(description="User feedback UUID.", required=true) @PathVariable(value="uuid") String uuid, HttpServletRequest request) throws Exception {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        Log.debug((String)"org.fao.geonet.api.userfeedback.UserFeedback", (Object)"deleteUserFeedback");
        IUserFeedbackService userFeedbackService = this.getUserFeedbackService();
        userFeedbackService.removeUserFeedback(uuid, request.getRemoteAddr());
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Operation(summary="Provides an average rating for a metadata record")
    @RequestMapping(value={"/records/{metadataUuid}/userfeedbackrating"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public UserFeedbackUtils.RatingAverage getMetadataRating(@Parameter(description="Metadata record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response, @Parameter(hidden=true) HttpSession httpSession) {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            return null;
        }
        try {
            Log.debug((String)"org.fao.geonet.api.userfeedback.UserFeedback", (Object)"getMetadataUserComments");
            AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
            if (metadata == null) {
                this.printOutputMessage(response, HttpStatus.FORBIDDEN, "Operation not allowed. User needs to be able to view the resource.");
                return null;
            }
            UserSession session = ApiUtils.getUserSession(httpSession);
            boolean published = true;
            if (session != null && session.isAuthenticated()) {
                published = false;
            }
            IUserFeedbackService userFeedbackService = this.getUserFeedbackService();
            UserFeedbackUtils utils = new UserFeedbackUtils();
            return utils.getAverage(userFeedbackService.retrieveUserFeedbackForMetadata(metadataUuid, -1, published));
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (String)("UserFeedbackAPI - getMetadataRating: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Operation(summary="Finds a specific user feedback")
    @RequestMapping(value={"/userfeedback/{uuid}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public UserFeedbackDTO getUserComment(@Parameter(description="User feedback UUID.", required=true) @PathVariable(value="uuid") String uuid, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        AbstractMetadata metadata;
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            return null;
        }
        Log.debug((String)"org.fao.geonet.api.userfeedback.UserFeedback", (Object)"getUserComment");
        IUserFeedbackService userFeedbackService = (IUserFeedbackService)ApplicationContextHolder.get().getBean("userFeedbackService");
        UserSession session = ApiUtils.getUserSession(httpSession);
        boolean published = true;
        if (session != null && session.isAuthenticated()) {
            published = false;
        }
        UserFeedback userfeedback = userFeedbackService.retrieveUserFeedback(uuid, published);
        UserFeedbackDTO dto = null;
        if (userfeedback != null) {
            dto = UserFeedbackUtils.convertToDto(userfeedback);
        }
        if ((metadata = ApiUtils.canViewRecord(userfeedback.getMetadata().getUuid(), request)) == null) {
            this.printOutputMessage(response, HttpStatus.FORBIDDEN, "Operation not allowed. User needs to be able to view the resource.");
            return null;
        }
        return dto;
    }

    @Operation(summary="Finds a list of user feedback for a specific records. ", description=" This list will include also the draft user feedback if the client is logged as reviewer.")
    @RequestMapping(value={"/records/{metadataUuid}/userfeedback"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<UserFeedbackDTO> getUserCommentsOnARecord(@Parameter(description="Metadata record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Maximum number of feedback to return.", required=false) @RequestParam(defaultValue="-1", required=false) int size, @Parameter(hidden=true) HttpServletResponse response, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        return this.getUserFeedback(metadataUuid, size, response, httpSession);
    }

    @Operation(summary="Finds a list of user feedback records. ", description=" This list will include also the draft user feedback if the client is logged as reviewer.")
    @RequestMapping(value={"/userfeedback"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<UserFeedbackDTO> getUserComments(@Parameter(description="Metadata record UUID.", required=false) @RequestParam(defaultValue="", required=false) String metadataUuid, @Parameter(description="Maximum number of feedback to return.", required=false) @RequestParam(defaultValue="-1", required=false) int size, @Parameter(hidden=true) HttpServletResponse response, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        return this.getUserFeedback(metadataUuid, size, response, httpSession);
    }

    private List<UserFeedbackDTO> getUserFeedback(String metadataUuid, int size, HttpServletResponse response, HttpSession httpSession) {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            return null;
        }
        try {
            Log.debug((String)"org.fao.geonet.api.userfeedback.UserFeedback", (Object)"getUserComments");
            IUserFeedbackService userFeedbackService = this.getUserFeedbackService();
            UserSession session = ApiUtils.getUserSession(httpSession);
            boolean published = true;
            if (session != null && session.isAuthenticated()) {
                published = false;
            }
            List<UserFeedback> listUserfeedback = null;
            listUserfeedback = metadataUuid == null || metadataUuid.equals("") ? userFeedbackService.retrieveUserFeedback(size, published) : userFeedbackService.retrieveUserFeedbackForMetadata(metadataUuid, size, published);
            return listUserfeedback.stream().map(feedback -> UserFeedbackUtils.convertToDto(feedback)).collect(Collectors.toList());
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (String)("UserFeedbackAPI - getUserFeedback: " + e.getMessage()), (Throwable)e);
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return null;
        }
    }

    private IUserFeedbackService getUserFeedbackService() {
        return (IUserFeedbackService)ApplicationContextHolder.get().getBean("userFeedbackService");
    }

    @Operation(summary="Creates a user feedback", description="Creates a user feedback in draft status if the user is not logged in.")
    @RequestMapping(value={"/userfeedback"}, produces={"application/json"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity newUserFeedback(@Parameter(name="uf") @RequestBody UserFeedbackDTO userFeedbackDto, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        try {
            StatusValueNotificationLevel notificationLevel;
            boolean validRecaptcha;
            UserSession session = ApiUtils.getUserSession(httpSession);
            Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
            ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
            Log.debug((String)"org.fao.geonet.api.userfeedback.UserFeedback", (Object)"newUserFeedback");
            IUserFeedbackService userFeedbackService = this.getUserFeedbackService();
            boolean recaptchaEnabled = this.settingManager.getValueAsBool("system/userSelfRegistration/recaptcha/enable");
            if (recaptchaEnabled && !(validRecaptcha = RecaptchaChecker.verify(userFeedbackDto.getCaptcha(), this.settingManager.getValue("system/userSelfRegistration/recaptcha/secretkey")))) {
                return new ResponseEntity((Object)messages.getString("recaptcha_not_valid"), HttpStatus.PRECONDITION_FAILED);
            }
            userFeedbackService.saveUserFeedback(UserFeedbackUtils.convertFromDto(userFeedbackDto, session != null ? session.getPrincipal() : null), request.getRemoteAddr());
            String notificationSetting = this.settingManager.getValue("system/localrating/notificationLevel");
            if (StringUtils.isNotEmpty((CharSequence)notificationSetting) && (notificationLevel = StatusValueNotificationLevel.valueOf((String)notificationSetting)) != null) {
                List toAddress;
                if (notificationLevel == StatusValueNotificationLevel.recordGroupEmail) {
                    List groupToNotify = DefaultStatusActions.getGroupToNotify((StatusValueNotificationLevel)notificationLevel, Arrays.asList(this.settingManager.getValue("system/localrating/notificationGroups").split("\\|")));
                    toAddress = groupToNotify.stream().filter(g -> StringUtils.isNotEmpty((CharSequence)g.getEmail())).map(Group::getEmail).collect(Collectors.toList());
                } else {
                    List userToNotify = DefaultStatusActions.getUserToNotify((StatusValueNotificationLevel)notificationLevel, Collections.singleton(Integer.parseInt(this.metadataUtils.getMetadataId(userFeedbackDto.getMetadataUUID()))), null);
                    toAddress = userToNotify.stream().filter(u -> StringUtils.isNotEmpty((CharSequence)u.getEmail())).map(User::getEmail).collect(Collectors.toList());
                }
                String catalogueName = this.settingManager.getValue("system/site/name");
                String title = XslUtil.getIndexField(null, (Object)userFeedbackDto.getMetadataUUID(), (Object)"resourceTitleObject", (Object)"");
                if (toAddress.size() > 0) {
                    try {
                        Locale[] feedbackLocales = this.feedbackLanguages.getLocales(locale);
                        LocalizedEmailComponent emailSubjectComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.SUBJECT, "new_user_rating", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
                        LocalizedEmailComponent emailMessageComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.MESSAGE, "new_user_rating_text", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
                        for (Locale feedbackLocale : feedbackLocales) {
                            emailSubjectComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)catalogueName), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)2, (Object)title)});
                            emailMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)this.metadataUtils.getDefaultUrl(userFeedbackDto.getMetadataUUID(), feedbackLocale.getISO3Language()))});
                        }
                        LocalizedEmail localizedEmail = new LocalizedEmail(Boolean.valueOf(false));
                        localizedEmail.addComponents(new LocalizedEmailComponent[]{emailSubjectComponent, emailMessageComponent});
                        MailUtil.sendMail(toAddress, (String)localizedEmail.getParsedSubject(feedbackLocales), (String)localizedEmail.getParsedMessage(feedbackLocales), (SettingManager)this.settingManager);
                    }
                    catch (IllegalArgumentException ex) {
                        Log.warning((String)"geonetwork.api", (Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            return new ResponseEntity(HttpStatus.CREATED);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (String)("UserFeedbackAPI - newUserFeedback: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Operation(summary="Send an email to catalogue administrator or record's contact", description="")
    @RequestMapping(value={"/records/{metadataUuid}/alert"}, produces={"application/json"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<String> sendEmailToContact(@Parameter(description="Metadata record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @Parameter(description="Recaptcha validation key.", required=false) @RequestParam(required=false, defaultValue="") String recaptcha, @Parameter(description="User name.", required=true) @RequestParam String name, @Parameter(description="User organisation.", required=true) @RequestParam String org, @Parameter(description="User email address.", required=true) @RequestParam String email, @Parameter(description="A comment or question.", required=true) @RequestParam String comments, @Parameter(description="User phone number.", required=false) @RequestParam(required=false, defaultValue="") String phone, @Parameter(description="Email subject.", required=false) @RequestParam(required=false, defaultValue="feedback_subject_userFeedback") String subject, @Parameter(description="User function.", required=false) @RequestParam(required=false, defaultValue="-") String function, @Parameter(description="Comment type.", required=false) @RequestParam(required=false, defaultValue="-") String type, @Parameter(description="Comment category.", required=false) @RequestParam(required=false, defaultValue="-") String category, @Parameter(description="List of record's contact to send this email (separated by comma).", required=false) @RequestParam(required=false, defaultValue="") String metadataEmail, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        boolean validRecaptcha;
        AbstractMetadata md = ApiUtils.canViewRecord(metadataUuid, request);
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
        Locale[] feedbackLocales = this.feedbackLanguages.getLocales(locale);
        boolean recaptchaEnabled = this.settingManager.getValueAsBool("system/userSelfRegistration/recaptcha/enable");
        if (recaptchaEnabled && !(validRecaptcha = RecaptchaChecker.verify(recaptcha, this.settingManager.getValue("system/userSelfRegistration/recaptcha/secretkey")))) {
            return new ResponseEntity((Object)messages.getString("recaptcha_not_valid"), HttpStatus.PRECONDITION_FAILED);
        }
        String to = this.settingManager.getValue("system/feedback/email");
        String catalogueName = this.settingManager.getValue("system/site/name");
        HashSet<String> toAddress = new HashSet<String>();
        toAddress.add(to);
        if (StringUtils.isNotBlank((CharSequence)metadataEmail)) {
            String[] metadataAddresses;
            for (String metadataAddress : metadataAddresses = StringUtils.split((String)metadataEmail, (String)",")) {
                String cleanMetadataAddress = StringUtils.trimToEmpty((String)metadataAddress);
                if (cleanMetadataAddress.isEmpty() || !md.getData().contains(cleanMetadataAddress)) continue;
                toAddress.add(cleanMetadataAddress);
            }
        }
        LocalizedEmailComponent emailSubjectComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.SUBJECT, "user_feedback_title", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
        LocalizedEmailComponent emailMessageComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.MESSAGE, "user_feedback_text", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
        for (Locale feedbackLocale : feedbackLocales) {
            emailSubjectComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)catalogueName), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.INDEX_FIELD, (Object)2, (Object)"resourceTitleObject", metadataUuid), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.MESSAGE_OR_JSON_KEY, (Object)3, (Object)subject)});
            emailMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)name), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)2, (Object)org), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)3, (Object)function), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)4, (Object)email), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)5, (Object)phone), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.INDEX_FIELD, (Object)6, (Object)"resourceTitleObject", metadataUuid), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.MESSAGE_OR_JSON_KEY, (Object)7, (Object)type), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.MESSAGE_OR_JSON_KEY, (Object)8, (Object)category), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)9, (Object)comments), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)10, (Object)this.metadataUtils.getDefaultUrl(metadataUuid, locale.getISO3Language()))});
        }
        LocalizedEmail localizedEmail = new LocalizedEmail(Boolean.valueOf(false));
        localizedEmail.addComponents(new LocalizedEmailComponent[]{emailSubjectComponent, emailMessageComponent});
        MailUtil.sendMail(new ArrayList(toAddress), (String)localizedEmail.getParsedSubject(feedbackLocales), (String)localizedEmail.getParsedMessage(feedbackLocales), (SettingManager)this.settingManager);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    private void printOutputMessage(HttpServletResponse response, HttpStatus code, String message) throws IOException {
        response.setStatus(code.value());
        PrintWriter out = response.getWriter();
        response.setContentType("text/html");
        out.println(message);
        response.flushBuffer();
    }

    @Operation(summary="Publishes a feedback", description="For reviewers")
    @RequestMapping(value={"/userfeedback/{uuid}/publish"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="User feedback published.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Operation not allowed. Only Reviewvers can access it."), @ApiResponse(responseCode="404", description="Resource not found.")})
    @ResponseBody
    public ResponseEntity publishFeedback(@Parameter(description="User feedback UUID.", required=true) @PathVariable(value="uuid") String uuid, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        try {
            UserSession session = ApiUtils.getUserSession(httpSession);
            IUserFeedbackService userFeedbackService = this.getUserFeedbackService();
            userFeedbackService.publishUserFeedback(uuid, session.getPrincipal());
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (String)("UserFeedbackAPI - publish: " + e.getMessage()), (Throwable)e);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

