/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.extent;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.records.extent.BaseMapRenderer;
import org.fao.geonet.api.records.extent.ExpandFactor;
import org.fao.geonet.api.regions.GeomFormat;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.region.Region;
import org.fao.geonet.kernel.region.RegionNotFoundEx;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.setting.SettingManager;
import org.geotools.api.metadata.extent.Extent;
import org.geotools.api.metadata.extent.GeographicBoundingBox;
import org.geotools.api.metadata.extent.GeographicExtent;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.awt.IdentityPointTransformation;
import org.locationtech.jts.awt.PointShapeFactory;
import org.locationtech.jts.awt.PointTransformation;
import org.locationtech.jts.awt.ShapeWriter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.springframework.context.ConfigurableApplicationContext;

public class MapRenderer {
    private static final double WGS_DIAG = Math.sqrt(Math.pow(360.0, 2.0) + Math.pow(180.0, 2.0));
    private final ServiceContext context;

    public MapRenderer(ServiceContext context) {
        this.context = context;
    }

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Dimension screenSize) {
        double scaleX = screenSize.getWidth() / mapExtent.getWidth();
        double scaleY = screenSize.getHeight() / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + screenSize.getHeight();
        return new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
    }

    public static Geometry getGeometryExtent(Geometry geom, String srs, boolean useGeodesicExtents) {
        boolean isGlobalSrs = srs.equals("EPSG:4326") || srs.equals("EPSG:3857");
        return !isGlobalSrs && !useGeodesicExtents ? geom.getEnvelope() : geom;
    }

    public static Geometry computeGeomInDomainOfValidity(Geometry geom, CoordinateReferenceSystem mapCRS) {
        Extent domainOfValidity = mapCRS.getDomainOfValidity();
        Geometry adjustedGeom = geom;
        if (domainOfValidity != null) {
            for (GeographicExtent extent : domainOfValidity.getGeographicElements()) {
                if (extent == null || Boolean.FALSE.equals(extent.getInclusion()) || !(extent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox box = (GeographicBoundingBox)extent;
                Envelope env = new Envelope(box.getWestBoundLongitude(), box.getEastBoundLongitude(), box.getSouthBoundLatitude(), box.getNorthBoundLatitude());
                if (env.contains(geom.getEnvelopeInternal())) {
                    return geom;
                }
                Polygon extentPolygon = JTS.toGeometry((Envelope)env);
                adjustedGeom = geom.intersection((Geometry)extentPolygon);
            }
            return adjustedGeom;
        }
        return geom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage render(String id, String srs, Integer width, Integer height, String background, String geomParam, String geomType, String geomSrs, String fillColor, String strokeColor) throws Exception {
        BufferedImage image;
        ConfigurableApplicationContext appContext = this.context.getApplicationContext();
        Map regionGetMapBackgroundLayers = (Map)appContext.getBean("regionGetMapBackgroundLayers", Map.class);
        SortedSet regionGetMapExpandFactors = (SortedSet)appContext.getBean("regionGetMapExpandFactors", SortedSet.class);
        SettingManager settingManager = (SettingManager)appContext.getBean(SettingManager.class);
        boolean useGeodesicExtents = settingManager.getValueAsBool("region/getmap/useGeodesicExtents", false);
        Geometry geom = null;
        if (id != null) {
            RegionsDAO regionsDAO;
            Collection daos = this.context.getApplicationContext().getBeansOfType(RegionsDAO.class).values();
            Iterator iterator = daos.iterator();
            while (iterator.hasNext() && (geom = (regionsDAO = (RegionsDAO)iterator.next()).getGeom(this.context, id, false, srs)) == null) {
            }
            if (geom == null) {
                throw new RegionNotFoundEx(id);
            }
        } else {
            GeomFormat format = GeomFormat.find(geomType);
            geom = format.parse(geomParam);
            if (!geomSrs.equals(srs)) {
                CoordinateReferenceSystem mapCRS = Region.decodeCRS((String)srs);
                CoordinateReferenceSystem geomCRS = Region.decodeCRS((String)geomSrs);
                geom = MapRenderer.computeGeomInDomainOfValidity(geom, mapCRS);
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)mapCRS, (boolean)true);
                geom = JTS.transform((Geometry)geom, (MathTransform)transform);
            }
        }
        boolean isPoint = geom.getGeometryType().equals("Point") || geom.getGeometryType().equals("GeometryCollection") && geom.getNumGeometries() == 1 && geom.getGeometryN(0).getGeometryType().equals("Point");
        int pointBufferSize = 150;
        Envelope bboxOfImage = new Envelope(isPoint ? geom.buffer((double)pointBufferSize).getEnvelopeInternal() : geom.getEnvelopeInternal());
        ExpandFactor factor = this.calculateExpandFactor(regionGetMapExpandFactors, bboxOfImage, srs);
        double expandFactor = factor.factor;
        if (factor.isSquareImage()) {
            height = width;
            bboxOfImage.expandBy(bboxOfImage.getWidth() * expandFactor, bboxOfImage.getWidth() * expandFactor);
        } else {
            bboxOfImage.expandBy(bboxOfImage.getWidth() * expandFactor, bboxOfImage.getHeight() * expandFactor);
        }
        Dimension imageDimensions = this.calculateImageSize(bboxOfImage, width, height);
        Throwable error = null;
        if (background != null) {
            BufferedImage baseMapImage;
            if (background.equalsIgnoreCase("settings")) {
                String bgSetting = settingManager.getValue("region/getmap/background");
                if (bgSetting.startsWith("http://") || bgSetting.startsWith("https://") || bgSetting.startsWith("{")) {
                    background = settingManager.getValue("region/getmap/background");
                } else if (regionGetMapBackgroundLayers.containsKey(bgSetting)) {
                    background = (String)regionGetMapBackgroundLayers.get(bgSetting);
                }
            } else if (regionGetMapBackgroundLayers.containsKey(background)) {
                background = (String)regionGetMapBackgroundLayers.get(background);
            }
            BaseMapRenderer baseMapRenderer = new BaseMapRenderer(background);
            baseMapRenderer.srs(srs).bbox(bboxOfImage).imageDimensions(imageDimensions).context(this.context);
            image = baseMapImage = baseMapRenderer.render();
        } else {
            image = new BufferedImage(imageDimensions.width, imageDimensions.height, 2);
        }
        Graphics2D graphics = image.createGraphics();
        try {
            if (error != null) {
                graphics.drawString(error.getMessage(), 0, imageDimensions.height / 2);
            }
            Color geomFillColor = this.getColor(fillColor, new Color(0, 0, 0, 30));
            Color geomStrokeColor = this.getColor(strokeColor, new Color(0, 0, 0, 255));
            AffineTransform worldToScreenTransform = MapRenderer.worldToScreenTransform(bboxOfImage, imageDimensions);
            int pointSize = 5;
            ShapeWriter shapeWriter = new ShapeWriter((PointTransformation)new IdentityPointTransformation(), (PointShapeFactory)new PointShapeFactory.Circle((double)pointSize * bboxOfImage.getWidth() / imageDimensions.getWidth()));
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                Geometry geomExtent = MapRenderer.getGeometryExtent(geom.getGeometryN(i), srs, useGeodesicExtents);
                Shape shape = worldToScreenTransform.createTransformedShape(shapeWriter.toShape(geomExtent));
                graphics.setColor(geomFillColor);
                graphics.fill(shape);
                graphics.setColor(geomStrokeColor);
                graphics.setStroke(new BasicStroke(2.0f));
                graphics.draw(shape);
            }
        }
        finally {
            graphics.dispose();
        }
        return image;
    }

    private Color getColor(String color, Color defaultColor) {
        if (StringUtils.isNotEmpty((String)color)) {
            String[] colorsConfig = color.split(",");
            if (colorsConfig.length == 4) {
                try {
                    return new Color(Integer.parseInt(colorsConfig[0]), Integer.parseInt(colorsConfig[1]), Integer.parseInt(colorsConfig[2]), Integer.parseInt(colorsConfig[3]));
                }
                catch (Exception e) {
                    throw new BadParameterEx(String.format("Invalid color configuration '%s'. Error is '%s'. Format must be 'RED,GREEN,BLUE,ALPHA' with integer value from 0 to 255.", color, e.getMessage()));
                }
            }
            throw new BadParameterEx(String.format("Invalid color configuration '%s'. Format must be 'RED,GREEN,BLUE,ALPHA' with integer value from 0 to 255.", color));
        }
        return defaultColor;
    }

    private ExpandFactor calculateExpandFactor(SortedSet<ExpandFactor> regionGetMapExpandFactors, Envelope bboxOfImage, String srs) throws Exception {
        CoordinateReferenceSystem crs = Region.decodeCRS((String)srs);
        ReferencedEnvelope env = new ReferencedEnvelope(bboxOfImage, crs);
        env = env.transform(Region.WGS84, true);
        double diag = Math.sqrt(Math.pow(env.getWidth(), 2.0) + Math.pow(env.getHeight(), 2.0));
        double scale = diag / WGS_DIAG;
        for (ExpandFactor factor : regionGetMapExpandFactors) {
            if (!(scale < factor.proportion)) continue;
            return factor;
        }
        return regionGetMapExpandFactors.last();
    }

    private Dimension calculateImageSize(Envelope bboxOfImage, Integer width, Integer height) {
        if (width != null) {
            return new Dimension(width, (int)Math.round(bboxOfImage.getHeight() / bboxOfImage.getWidth() * (double)width.intValue()));
        }
        return new Dimension((int)Math.round(bboxOfImage.getWidth() / bboxOfImage.getHeight() * (double)height.intValue()), height);
    }
}

