/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.attachments.Sort;
import org.fao.geonet.api.records.attachments.SortConverter;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataResourceVisibilityConverter;
import org.fao.geonet.events.history.AttachmentAddedEvent;
import org.fao.geonet.events.history.AttachmentDeletedEvent;
import org.fao.geonet.util.ImageUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/records/{metadataUuid}/attachments"})
@Tag(name="records", description="Metadata record operations")
public class AttachmentsApi {
    public static final Integer MIN_IMAGE_SIZE = 1;
    public static final Integer MAX_IMAGE_SIZE = 2048;
    public static final Integer BUFFER_SIZE = 8192;
    private final ApplicationContext appContext = ApplicationContextHolder.get();
    private Store store;

    public AttachmentsApi() {
    }

    public AttachmentsApi(Store store) {
        this.store = store;
    }

    public static String getFileContentType(Path file) throws IOException {
        Object contentType = Files.probeContentType(file);
        if (contentType == null) {
            String ext;
            switch (ext = com.google.common.io.Files.getFileExtension((String)file.getFileName().toString()).toLowerCase()) {
                case "png": 
                case "gif": 
                case "bmp": {
                    contentType = "image/" + ext;
                    break;
                }
                case "tif": 
                case "tiff": {
                    contentType = "image/tiff";
                    break;
                }
                case "jpg": 
                case "jpeg": {
                    contentType = "image/jpeg";
                    break;
                }
                case "txt": {
                    contentType = "text/plain";
                    break;
                }
                case "htm": 
                case "html": {
                    contentType = "text/html";
                    break;
                }
                default: {
                    contentType = "application/" + ext;
                }
            }
        }
        return contentType;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    @PostConstruct
    public void init() {
        if (this.appContext != null) {
            this.store = (Store)this.appContext.getBean("resourceStore", Store.class);
        }
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(MetadataResourceVisibility.class, (PropertyEditor)new MetadataResourceVisibilityConverter());
        binder.registerCustomEditor(Sort.class, (PropertyEditor)new SortConverter());
    }

    public List<MetadataResource> getResources() {
        return null;
    }

    @Operation(summary="List all metadata attachments", description="<a href='https://docs.geonetwork-opensource.org/latest/user-guide/associating-resources/using-filestore/'>More info</a>")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the record attachments."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public List<MetadataResource> getAllResources(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="Sort by", example="type") @RequestParam(required=false, defaultValue="name") Sort sort, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, @RequestParam(required=false, defaultValue="*.*") String filter, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return this.store.getResources(context, metadataUuid, sort, filter, approved);
    }

    @Operation(summary="Delete all uploaded metadata resources")
    @RequestMapping(method={RequestMethod.DELETE}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Attachment added.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delResources(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        this.store.delResources(context, metadataUuid, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentDeletedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), "All attachments").publish((ApplicationContext)ApplicationContextHolder.get());
        }
    }

    @Operation(summary="Create a new resource for a given metadata")
    @PreAuthorize(value="hasAuthority('Editor')")
    @RequestMapping(method={RequestMethod.POST}, consumes={"multipart/form-data"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Attachment uploaded."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public MetadataResource putResource(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The sharing policy", example="public") @RequestParam(required=false, defaultValue="public") MetadataResourceVisibility visibility, @Parameter(description="The file to upload") @RequestParam(value="file") MultipartFile file, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        MetadataResource resource = this.store.putResource(context, metadataUuid, file, visibility, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null && file != null && !file.isEmpty()) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentAddedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), file.getOriginalFilename()).publish((ApplicationContext)ApplicationContextHolder.get());
        }
        return resource;
    }

    @Operation(summary="Create a new resource from a URL for a given metadata")
    @PreAuthorize(value="hasAuthority('Editor')")
    @RequestMapping(method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Attachment added."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public MetadataResource putResourceFromURL(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The sharing policy", example="public") @RequestParam(required=false, defaultValue="public") MetadataResourceVisibility visibility, @Parameter(description="The URL to load in the store") @RequestParam(value="url") URL url, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        MetadataResource resource = this.store.putResource(context, metadataUuid, url, visibility, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null && url != null) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentAddedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), url.toString()).publish((ApplicationContext)ApplicationContextHolder.get());
        }
        return resource;
    }

    @Operation(summary="Get a metadata resource")
    @RequestMapping(value={"/{resourceId:.+}"}, method={RequestMethod.GET})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Record attachment.", content={@Content(schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="206", description="Partial content for resumable downloads.", content={@Content(schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to download the resource.")})
    public ResponseEntity<Resource> getResource(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The resource identifier (ie. filename)", required=true) @PathVariable String resourceId, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, @Parameter(description="Size (only applies to images). From 1px to 2048px.", example="200") @RequestParam(required=false) Integer size, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        ApiUtils.canViewRecord(metadataUuid, request);
        final Store.ResourceHolder file = this.store.getResource(context, metadataUuid, resourceId, approved);
        long fileSize = Files.size(file.getPath());
        long fileLastModified = file.getMetadata().getLastModification().getTime();
        MediaType fileMediaType = MediaType.parseMediaType((String)AttachmentsApi.getFileContentType(file.getPath()));
        String fileETag = "\"" + DigestUtils.md5Hex((String)(file.getMetadata().getFilename() + fileLastModified + fileSize)) + "\"";
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setCacheControl(CacheControl.noCache());
        responseHeaders.setLastModified(fileLastModified);
        responseHeaders.setETag(fileETag);
        if (new ServletWebRequest(request).checkNotModified(fileETag, fileLastModified)) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_MODIFIED).headers(responseHeaders)).build();
        }
        if (fileMediaType.getType().equals("image") && size != null) {
            return this.serveResizedImage(file.getPath(), file.getMetadata().getFilename(), responseHeaders, size);
        }
        responseHeaders.setContentType(fileMediaType);
        responseHeaders.setContentDisposition(ContentDisposition.attachment().filename(file.getMetadata().getFilename()).build());
        responseHeaders.setContentLength(fileSize);
        PathResource resource = new PathResource(file.getPath()){

            @NonNull
            public InputStream getInputStream() throws IOException {
                InputStream delegate = super.getInputStream();
                return new FilterInputStream(delegate){

                    @Override
                    public void close() throws IOException {
                        try {
                            super.close();
                        }
                        finally {
                            file.close();
                        }
                    }
                };
            }
        };
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)resource);
    }

    @Operation(summary="Update the metadata resource visibility")
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Attachment visibility updated."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @RequestMapping(value={"/{resourceId:.+}"}, method={RequestMethod.PATCH}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataResource patchResource(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The resource identifier (ie. filename)", required=true) @PathVariable String resourceId, @Parameter(description="The visibility", required=true, example="public") @RequestParam(required=true) MetadataResourceVisibility visibility, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return this.store.patchResourceStatus(context, metadataUuid, resourceId, visibility, approved);
    }

    @Operation(summary="Delete a metadata resource")
    @PreAuthorize(value="hasAuthority('Editor')")
    @RequestMapping(value={"/{resourceId:.+}"}, method={RequestMethod.DELETE})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Attachment visibility removed.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delResource(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The resource identifier (ie. filename)", required=true) @PathVariable String resourceId, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        this.store.delResource(context, metadataUuid, resourceId, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentDeletedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), resourceId).publish((ApplicationContext)ApplicationContextHolder.get());
        }
    }

    private ResponseEntity<Resource> serveResizedImage(Path imagePath, String originalImageName, HttpHeaders responseHeaders, int size) throws IOException {
        if (size < MIN_IMAGE_SIZE || size > MAX_IMAGE_SIZE) {
            throw new IllegalArgumentException(String.format("Image can only be resized from %d to %d. You requested %d.", MIN_IMAGE_SIZE, MAX_IMAGE_SIZE, size));
        }
        BufferedImage originalImage = ImageIO.read(imagePath.toFile());
        BufferedImage resizedImage = ImageUtil.resize((BufferedImage)originalImage, (int)size);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)resizedImage, "png", outputStream);
        ByteArrayResource imgResource = new ByteArrayResource(outputStream.toByteArray());
        String pngFilename = originalImageName.substring(0, originalImageName.lastIndexOf(46)) + ".png";
        responseHeaders.setContentType(MediaType.IMAGE_PNG);
        responseHeaders.setContentDisposition(ContentDisposition.attachment().filename(pngFilename).build());
        responseHeaders.setContentLength(imgResource.contentLength());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)imgResource);
    }
}

