/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.links;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.management.MalformedObjectNameException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.links.EmptySlot;
import org.fao.geonet.api.links.LinkAnalysisReport;
import org.fao.geonet.api.links.MAnalyseProcess;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Link;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.exceptions.OperationNotAllowedEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.kernel.url.UrlAnalyzer;
import org.fao.geonet.repository.LinkRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.specification.LinkSpecs;
import org.fao.geonet.utils.Log;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RestController
@RequestMapping(value={"/{portal}/api/records/links"})
@Tag(name="links", description="Record link operations")
public class LinksApi {
    public static final String LOGGER = "geonetwork.api.links";
    private static final int NUMBER_OF_SUBSEQUENT_PROCESS_MBEAN_TO_KEEP = 5;
    @Autowired
    protected ApplicationContext appContext;
    @Autowired
    LinkRepository linkRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    UrlAnalyzer urlAnalyser;
    @Autowired
    MBeanExporter mBeanExporter;
    @Autowired
    AccessManager accessManager;
    @Autowired
    SettingManager settingManager;
    private ArrayDeque<SelfNaming> mAnalyseProcesses = new ArrayDeque(5);

    @PostConstruct
    public void iniMBeansSlidingWindowWithEmptySlot() {
        for (int i = 0; i < 5; ++i) {
            EmptySlot emptySlot = new EmptySlot(this.settingManager.getSiteId(), i);
            this.mAnalyseProcesses.addFirst(emptySlot);
            try {
                this.mBeanExporter.registerManagedResource((Object)emptySlot, emptySlot.getObjectName());
                continue;
            }
            catch (MalformedObjectNameException e) {
                Log.error((String)LOGGER, (String)String.format("Error registering metadata links analysis process '%s'", this.settingManager.getSiteId()), (Throwable)e);
            }
        }
    }

    @Operation(summary="Get record links", description="")
    @Parameters(value={@Parameter(name="page", in=ParameterIn.QUERY, schema=@Schema(type="integer", format="int32"), description="Results page you want to retrieve (0..N)"), @Parameter(name="size", in=ParameterIn.QUERY, schema=@Schema(type="integer", format="int32"), description="Number of records per page."), @Parameter(name="sort", in=ParameterIn.QUERY, schema=@Schema(type="string"), description="Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. ")})
    @GetMapping(produces={"application/json"})
    @PreAuthorize(value="isAuthenticated()")
    public Page<Link> getRecordLinks(@Parameter(description="Filter, e.g. \"{url: 'png', lastState: 'ko', records: 'e421'}\", lastState being 'ok'/'ko'/'unknown'", required=false) @RequestParam(required=false) LinkFilter filter, @Parameter(description="Optional, filter links to records published in that group.", required=false) @RequestParam(required=false) Integer[] groupIdFilter, @Parameter(description="Optional, filter links to records created in that group.", required=false) @RequestParam(required=false) Integer[] groupOwnerIdFilter, @Parameter(description="Optional, filter links to http status.") @RequestParam(required=false) Integer[] httpErrorStatusValueFilter, @Parameter(description="Optional, filter links excluding harvested metadata.") @RequestParam(required=false, defaultValue="false") boolean excludeHarvestedMetadataFilter, @Parameter(hidden=true) Pageable pageRequest, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        return this.getLinks(filter, groupIdFilter, groupOwnerIdFilter, httpErrorStatusValueFilter, excludeHarvestedMetadataFilter, pageRequest, userSession);
    }

    @Operation(summary="Get record links", description="")
    @Parameters(value={@Parameter(name="page", in=ParameterIn.QUERY, schema=@Schema(type="integer", format="int32"), description="Results page you want to retrieve (0..N)"), @Parameter(name="size", in=ParameterIn.QUERY, schema=@Schema(type="integer", format="int32"), description="Number of records per page."), @Parameter(name="sort", in=ParameterIn.QUERY, schema=@Schema(type="string"), description="Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. ")})
    @PostMapping(consumes={"application/x-www-form-urlencoded"}, produces={"application/json"})
    @PreAuthorize(value="isAuthenticated()")
    public Page<Link> getRecordLinksPost(@Parameter(description="Filter, e.g. \"{url: 'png', lastState: 'ko', records: 'e421'}\", lastState being 'ok'/'ko'/'unknown'", required=false) @RequestParam(required=false) LinkFilter filter, @Parameter(description="Optional, filter links to records published in that group.", required=false) @RequestParam(required=false) Integer[] groupIdFilter, @Parameter(description="Optional, filter links to records created in that group.", required=false) @RequestParam(required=false) Integer[] groupOwnerIdFilter, @Parameter(description="Optional, filter links to http status.") @RequestParam(required=false) Integer[] httpStatusValueFilter, @Parameter(description="Optional, filter links excluding harvested metadata.") @RequestParam(required=false, defaultValue="false") boolean excludeHarvestedMetadataFilter, @Parameter(hidden=true) Pageable pageRequest, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        return this.getLinks(filter, groupIdFilter, groupOwnerIdFilter, httpStatusValueFilter, excludeHarvestedMetadataFilter, pageRequest, userSession);
    }

    private Page<Link> getLinks(LinkFilter filter, Integer[] groupIdFilter, Integer[] groupOwnerIdFilter, Integer[] httpStatusValueFilter, boolean excludeHarvestedMetadataFilter, Pageable pageRequest, UserSession userSession) throws SQLException, JSONException {
        List editingGroupList;
        Integer[] editingGroups = null;
        if (userSession.getProfile() != Profile.Administrator && !(editingGroupList = AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Editor)).isEmpty()) {
            editingGroups = editingGroupList.toArray(new Integer[editingGroupList.size()]);
        }
        if (filter == null && (groupIdFilter != null || groupOwnerIdFilter != null || httpStatusValueFilter != null || editingGroups != null || excludeHarvestedMetadataFilter)) {
            return this.linkRepository.findAll(LinkSpecs.filter(null, null, null, (Integer[])groupIdFilter, (Integer[])groupOwnerIdFilter, (Integer[])httpStatusValueFilter, (boolean)excludeHarvestedMetadataFilter, (Integer[])editingGroups), pageRequest);
        }
        if (filter != null) {
            Integer stateToMatch = null;
            String url = null;
            List associatedRecords = null;
            if (filter.getLastState() != null) {
                stateToMatch = 0;
                if (filter.getLastState().equalsIgnoreCase("ok")) {
                    stateToMatch = 1;
                } else if (filter.getLastState().equalsIgnoreCase("ko")) {
                    stateToMatch = -1;
                }
            }
            if (filter.getUrl() != null) {
                url = filter.getUrl();
            }
            if (filter.getRecords() != null) {
                associatedRecords = Arrays.stream(filter.getRecords().split(" ")).collect(Collectors.toList());
            }
            return this.linkRepository.findAll(LinkSpecs.filter((String)url, (Integer)stateToMatch, associatedRecords, (Integer[])groupIdFilter, (Integer[])groupOwnerIdFilter, (Integer[])httpStatusValueFilter, (boolean)excludeHarvestedMetadataFilter, (Integer[])editingGroups), pageRequest);
        }
        return this.linkRepository.findAll(pageRequest);
    }

    @Operation(description="Get record links as CSV")
    @Parameters(value={@Parameter(name="page", in=ParameterIn.QUERY, schema=@Schema(type="integer", format="int32"), description="Results page you want to retrieve (0..N)"), @Parameter(name="size", in=ParameterIn.QUERY, schema=@Schema(type="integer", format="int32"), description="Number of records per page."), @Parameter(name="sort", in=ParameterIn.QUERY, schema=@Schema(type="string"), description="Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. ")})
    @GetMapping(path={"/csv"}, produces={"text/plain"})
    @PreAuthorize(value="isAuthenticated()")
    public void getRecordLinksAsCsv(@Parameter(description="Filter, e.g. \"{url: 'png', lastState: 'ko', records: 'e421'}\", lastState being 'ok'/'ko'/'unknown'", required=false) @RequestParam(required=false) LinkFilter filter, @Parameter(description="Optional, filter links to records published in that group.", required=false) @RequestParam(required=false) Integer[] groupIdFilter, @Parameter(description="Optional, filter links to records created in that group.", required=false) @RequestParam(required=false) Integer[] groupOwnerIdFilter, @Parameter(description="Optional, filter links to http status.") @RequestParam(required=false) Integer[] httpStatusValueFilter, @Parameter(description="Optional, filter links excluding harvested metadata.") @RequestParam(required=false, defaultValue="false") boolean excludeHarvestedMetadataFilter, @Parameter(hidden=true) Pageable pageRequest, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletResponse response) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        Page<Link> links = this.getLinks(filter, groupIdFilter, groupOwnerIdFilter, httpStatusValueFilter, excludeHarvestedMetadataFilter, pageRequest, userSession);
        response.setHeader("Content-disposition", "attachment; filename=links.csv");
        LinkAnalysisReport.create(links, response.getWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Analyze records links", description="One of uuids or bucket parameter is required if not an Administrator. Only records that you can edit will be validated.")
    @PostMapping(path={"/analyze"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    public SimpleMetadataProcessingReport analyzeRecordLinks(@Parameter(description="Record UUIDs. If null current selection is used.") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Only allowed if Administrator.") @RequestParam(required=false, defaultValue="true") boolean removeFirst, @RequestParam(required=false, defaultValue="false") boolean analyze, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request) {
        boolean isAdministrator;
        MAnalyseProcess registredMAnalyseProcess = this.getRegistredMAnalyseProcess();
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        UserSession session = ApiUtils.getUserSession(httpSession);
        boolean bl = isAdministrator = session.getProfile() == Profile.Administrator;
        if (isAdministrator && removeFirst) {
            registredMAnalyseProcess.deleteAll();
        }
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        HashSet ids = Sets.newHashSet();
        if (uuids != null || StringUtils.isNotEmpty((String)bucket)) {
            try {
                Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
                for (String uuid : records) {
                    if (!this.metadataUtils.existsMetadataUuid(uuid)) {
                        report.incrementNullRecords();
                    }
                    for (AbstractMetadata metadataRecord : this.metadataRepository.findAllByUuid(uuid)) {
                        if (!this.accessManager.canEdit(serviceContext, String.valueOf(metadataRecord.getId()))) {
                            report.addNotEditableMetadataId(metadataRecord.getId());
                            continue;
                        }
                        ids.add(metadataRecord.getId());
                        report.addMetadataId(metadataRecord.getId());
                        report.incrementProcessedRecords();
                    }
                }
            }
            catch (Exception e) {
                report.addError(e);
            }
            finally {
                report.close();
            }
        } else {
            if (isAdministrator) {
                List metadataList = this.metadataRepository.findAll();
                for (Metadata m : metadataList) {
                    ids.add(m.getId());
                    report.addMetadataId(m.getId());
                    report.incrementProcessedRecords();
                }
            } else {
                throw new OperationNotAllowedEx(String.format("Only administrator can trigger link analysis on the entire catalogue. This is not allowed for %s.", session.getProfile()));
            }
            report.close();
        }
        registredMAnalyseProcess.processMetadataAndTestLink(analyze, ids);
        return report;
    }

    @Operation(summary="Analyze one or more links", description="")
    @PostMapping(path={"/analyzeurl"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    public void analyzeLinks(@Parameter(description="URL") @RequestParam(required=false) String[] url) {
        MAnalyseProcess registredMAnalyseProcess = this.getRegistredMAnalyseProcess();
        registredMAnalyseProcess.testLink(Lists.newArrayList((Object[])url));
    }

    @Operation(summary="Remove all links and status history", description="")
    @DeleteMapping(produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Administrator')")
    public ResponseEntity<Void> purgeAll() {
        this.urlAnalyser.deleteAll();
        this.cleanupFinishedMAnalyseProcesses();
        return ResponseEntity.noContent().build();
    }

    private MAnalyseProcess getRegistredMAnalyseProcess() {
        this.cleanupFinishedMAnalyseProcesses();
        MAnalyseProcess mAnalyseProcess = new MAnalyseProcess(this.settingManager.getSiteId(), this.linkRepository, this.metadataRepository, this.urlAnalyser, this.appContext);
        this.mBeanExporter.registerManagedResource((Object)mAnalyseProcess, mAnalyseProcess.getObjectName());
        this.mAnalyseProcesses.addFirst(mAnalyseProcess);
        return mAnalyseProcess;
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(LinkFilter.class, (PropertyEditor)new PropertyEditorSupport(){
            Object value;

            @Override
            public Object getValue() {
                return this.value;
            }

            @Override
            public void setAsText(String text) throws IllegalArgumentException {
                this.value = new Gson().fromJson(text, LinkFilter.class);
            }
        });
    }

    private void cleanupFinishedMAnalyseProcesses() {
        try {
            ArrayList processToRemove = new ArrayList();
            this.mAnalyseProcesses.forEach(p -> {
                MAnalyseProcess process;
                if (!(p instanceof EmptySlot) && (process = (MAnalyseProcess)p).isProcessFinished()) {
                    processToRemove.add(process);
                }
            });
            Iterator it = processToRemove.iterator();
            while (it.hasNext()) {
                this.mBeanExporter.unregisterManagedResource(((SelfNaming)it.next()).getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            Log.error((String)LOGGER, (String)String.format("Error unregistering metadata links analysis process '%s'", this.settingManager.getSiteId()), (Throwable)e);
        }
    }

    private static class LinkFilter {
        private String url;
        private String lastState;
        private String records;

        private LinkFilter() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getLastState() {
            return this.lastState;
        }

        public void setLastState(String lastState) {
            this.lastState = lastState;
        }

        public String getRecords() {
            return this.records;
        }

        public void setRecords(String records) {
            this.records = records;
        }
    }
}

