/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.auditable;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fao.geonet.auditable.BaseAuditableService;
import org.fao.geonet.auditable.model.RevisionInfo;
import org.fao.geonet.domain.auditable.AuditableEntity;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/auditable"})
@Tag(name="auditable", description="Entity auditable operations")
@RestController(value="auditable")
public class AuditableApi {
    private final Map<String, BaseAuditableService<? extends AuditableEntity>> factory = new HashMap<String, BaseAuditableService<? extends AuditableEntity>>();

    public AuditableApi(ListableBeanFactory beanFactory) {
        Collection auditableServiceBeans = beanFactory.getBeansOfType(BaseAuditableService.class).values();
        auditableServiceBeans.forEach(filter -> this.factory.put(filter.getEntityType().toLowerCase(), (BaseAuditableService<? extends AuditableEntity>)filter));
    }

    @Operation(summary="Get an entity history", description="")
    @GetMapping(value={"/{entityType}/{entityIdentifier}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Entity history details.")})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public List<RevisionInfo> getEntityHistory(@Parameter(description="Entity type", required=true) @PathVariable String entityType, @Parameter(description="Entity identifier", required=true) @PathVariable Integer entityIdentifier) {
        BaseAuditableService<? extends AuditableEntity> service = this.factory.get(entityType);
        return service.getEntityHistory(entityIdentifier);
    }
}

